const express = require('express');
const os = require('os');
const readline = require('readline');
const { build, buildAndroid, buildIos } = require('./buildCocos');

const networkInfo = os.networkInterfaces();

let host = '';
// 优先使用192.168.33.x网段的IP
for (const infos of Object.values(networkInfo)) {
  for (const info of infos) {
    if (info.family == 'IPv4') {
      if (info.address.startsWith('192.168.33.')) {
        host = info.address;
        break;
      }
    }
  }
  if (host) break;
}

// 如果没有找到192.168.33.x网段的IP，则使用其他非本地IP
if (!host) {
  for (const infos of Object.values(networkInfo)) {
    for (const info of infos) {
      if (info.family == 'IPv4') {
        if (info.address.split('.')[0] != "127") {
          host = info.address;
        }
      }
    }
  }
}

var app = express();

// 添加 CORS 中间件
app.use((req, res, next) => {
  res.header('Access-Control-Allow-Origin', '*');
  res.header('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, OPTIONS');
  res.header('Access-Control-Allow-Headers', 'Origin, X-Requested-With, Content-Type, Accept, Authorization');
  
  // 处理预检请求
  if (req.method === 'OPTIONS') {
    res.sendStatus(200);
  } else {
    next();
  }
});

app.use('/dist', express.static('dist'));
app.use('/form', express.static('form'));

app.get('/', function (req, res) {
  res.send('Hello World');
})

let port = '';
var server = app.listen(8081, '0.0.0.0', function () {

  port = server.address().port

  console.log("测试服务已启动：%s:%s", host, port)
  console.log("如果已经build可访问如下地址");
  console.log("http://%s:%s/dist/play/index.html", host, port)
  console.log("http://%s:%s/dist/play/index.html", "localhost", port)
  console.log('-----------------');
  console.log("    输入 build 构建安卓脚本");
  console.log("    输入 build ios 构建IOS脚本");
  console.log('-----------------');

})

const rl = readline.createInterface({
  input: process.stdin,
  output: process.stdout
})
rl.on('line', async (str) => {
  if (str.trim() == 'build') {
    await buildAndroid();
  } else if (str.trim() == 'build ios') {
    await buildIos();
  }
  console.log("服务器：%s:%s", host, port)
})
