# Cocos Creator 项目架构文档

## 项目概述

这是一个基于 Cocos Creator 2.4.5 的游戏开发项目，集成了多种开发工具和组件，包括表单编辑器、Angular 组件、自定义扩展包等。项目名称为 "play"，主要用于创建交互式的教育类游戏内容。

## 整体架构

```
testzg001/
├── 核心游戏引擎 (Cocos Creator)
├── 构建和发布系统 (Node.js)
├── 表单编辑器 (HTML/JavaScript + Angular)
├── 自定义扩展包 (Cocos Creator Extensions)
└── 配置和设置文件
```

## 详细模块分析

### 1. 项目根目录结构

#### 1.1 核心配置文件
- **package.json**: Node.js 项目配置，定义了构建脚本和依赖
  - 主要脚本: `publish`(构建)、`start`(启动服务器)
  - 核心依赖: express、compressing、uuid、base-64
- **project.json**: Cocos Creator 项目配置
  - 引擎版本: cocos-creator-js 2.4.5
  - 项目ID: 9af72fd2-44a6-4131-8ea3-3e1b3fa22231
- **tsconfig.json**: TypeScript 编译配置
  - 目标: ES5，支持装饰器和CommonJS模块

#### 1.2 构建系统 (/bin/)
- **app.js**: 开发服务器
  - 启动Express服务器 (端口8081)
  - 提供静态文件服务 (/dist, /form)
  - 支持交互式构建命令
- **build.js**: 构建入口脚本
- **buildCocos.js**: 核心构建逻辑 (444行)
  - 支持多平台构建 (Web、Android、iOS)
  - 资源压缩和UUID替换
  - 表单组件构建集成
- **utils.js**: 构建工具函数

### 2. Cocos Creator 游戏资源 (/assets/)

#### 2.1 资源组织结构
```
assets/cocos_generator/
├── audios/          # 音频资源
│   └── btn.mp3      # 按钮音效
├── dragonBones/     # 骨骼动画资源
├── fonts/           # 字体资源
│   └── BRLNSDB.TTF  # 自定义字体
├── scene/           # 场景文件
│   ├── cocos_generator.fire  # 主场景
│   └── cocos_generator.ts    # 场景脚本
├── script/          # 脚本文件
│   ├── MyCocosSceneComponent.ts  # 基础场景组件
│   ├── defaultData.ts            # 默认数据配置
│   ├── runtime.js               # 运行时脚本
│   └── util.ts                  # 工具函数
└── textures/        # 纹理资源
    ├── bg.jpg       # 背景图
    ├── icon.png     # 图标
    └── btn_*.png    # 按钮纹理
```

#### 2.2 核心脚本架构
- **MyCocosSceneComponent.ts**: 基础场景组件类
  - 屏幕适配逻辑
  - 资源预加载管理
  - 通用工具方法
- **cocos_generator.ts**: 主场景控制器
  - 继承自MyCocosSceneComponent
  - 实现具体的游戏逻辑
  - 支持左右切换功能

### 3. 表单编辑器系统

#### 3.1 HTML版本 (/form/)
- **index.html**: 基于ACE编辑器的JSON配置界面
  - 集成ACE代码编辑器
  - 支持文件上传功能
  - 实时数据同步到courseware系统
- **ace/**: ACE编辑器相关文件
  - 支持JavaScript和JSON语法高亮
  - Chrome主题配置

#### 3.2 Angular版本 (/form_angular/)
- **技术栈**: Angular 9.0.2 + ng-zorro-antd UI组件库
- **核心功能**:
  - 现代化的表单编辑界面
  - 支持文件上传和压缩
  - 集成阿里云OSS存储
- **构建配置**: 
  - 支持AOT编译和构建优化
  - 自定义发布脚本

### 4. 自定义扩展包 (/packages/)

#### 4.1 check-file-name
- **功能**: 文件名检查工具
- **用途**: 确保资源文件命名规范

#### 4.2 replace-uuid
- **功能**: UUID替换工具
- **用途**: 批量替换资源UUID引用

#### 4.3 引用查找器 (ccc-references-finder)
- **版本**: 1.3.0.20210929
- **功能**: 资源引用关系查找
- **特性**: 
  - 一键查找资源的所有引用
  - 精确到预制体或场景中的节点、组件和属性
  - 支持快捷键操作 (F6)

### 5. 项目配置 (/settings/)

#### 5.1 builder.json
- **构建配置**: 
  - 应用名称: "play"
  - 包名: org.cocos2d.demo
  - 支持横屏模式
  - 启用JS加密 (xxteaKey)
  - 支持多平台发布

#### 5.2 project.json
- **项目设置**: 记录模块事件和迁移历史

## 技术特点

### 1. 多平台支持
- Web端游戏运行
- Android/iOS原生应用
- 桌面端 (Mac/Windows)

### 2. 开发工具集成
- 实时预览服务器
- 自动化构建流程
- 资源管理工具
- 代码编辑器集成

### 3. 资源管理
- 统一的资源预加载机制
- UUID管理和替换
- 文件压缩和优化
- 多格式资源支持

### 4. 扩展性设计
- 插件化的扩展包系统
- 模块化的脚本架构
- 可配置的构建流程

## 开发流程

1. **资源准备**: 在assets目录下组织游戏资源
2. **脚本开发**: 基于MyCocosSceneComponent开发游戏逻辑
3. **配置编辑**: 使用form编辑器配置游戏参数
4. **构建发布**: 通过npm scripts执行构建
5. **测试验证**: 使用内置服务器进行测试

## 部署架构

```
开发环境 → 构建系统 → 静态资源 → CDN分发
    ↓         ↓         ↓        ↓
  源码编辑   资源压缩   文件托管   用户访问
```

## 总结

该项目是一个功能完整的Cocos Creator游戏开发框架，具有以下优势：

1. **完整的工具链**: 从开发到发布的完整流程支持
2. **多端适配**: 支持Web、移动端、桌面端多平台
3. **可视化配置**: 提供友好的配置编辑界面
4. **扩展性强**: 支持自定义扩展包和插件
5. **自动化程度高**: 集成构建、压缩、发布等自动化流程

该架构适合用于开发教育类交互游戏、H5小游戏等项目，具有良好的可维护性和扩展性。