# 游戏中心进度条功能说明

## 功能概述
为游戏中心页面添加了进度条功能，在调用`loadPageBundle`加载游戏资源时显示进度条，加载完成后自动隐藏。

## 主要特性
- 自动创建进度条UI组件
- 实时显示加载进度
- 支持通过属性面板自定义进度条样式
- 包含模拟进度功能作为备用方案
- 自动重写middleLayer组件的进度更新方法

## 使用方法

### 1. 自动创建进度条
进度条会在页面初始化时自动创建，无需手动配置。

### 2. 通过属性面板自定义
如果需要在编辑器中自定义进度条样式，可以在属性面板中设置以下属性：
- `progressBarContainer`: 进度条容器节点
- `progressBar`: 进度条组件
- `progressLabel`: 进度文本标签

### 3. 进度条显示时机
- 当用户点击游戏卡片时自动显示
- 在`loadPageBundle`调用期间保持显示
- 加载完成后自动隐藏

## 技术实现

### 进度条组件结构
```
progress_bar_container (容器)
├── bg_mask (背景遮罩)
├── loading_label (加载提示文本)
├── progress_bg (进度条背景)
├── progress_bar (进度条)
└── progress_label (进度百分比文本)
```

### 关键方法
- `showProgressBar()`: 显示进度条
- `hideProgressBar()`: 隐藏进度条
- `updateProgressBar(progress)`: 更新进度值
- `overrideProgressUpdate()`: 重写middleLayer的进度更新方法
- `startSimulatedProgress()`: 启动模拟进度更新
- `stopSimulatedProgress()`: 停止模拟进度更新

### 进度更新机制
1. **实际进度更新**: 通过重写middleLayer组件的`setLoadingProgressBar`方法
2. **模拟进度更新**: 作为备用方案，确保用户能看到进度变化
3. **自动隐藏**: 在`loadPageBundle`回调中自动隐藏进度条

## 样式配置
- 进度条容器尺寸: 400x120
- 进度条尺寸: 300x20
- 背景遮罩: 半透明黑色
- 进度条颜色: 蓝色
- 文本颜色: 白色

## 注意事项
1. 进度条会在页面初始化时自动创建
2. 模拟进度最多显示到90%，留10%给实际加载完成
3. 如果middleLayer组件没有正确调用进度更新，模拟进度会作为备用方案
4. 进度条会在加载完成后自动清理和隐藏

## 扩展功能
如需添加更多功能，可以考虑：
- 添加取消加载按钮
- 显示预计剩余时间
- 添加加载失败重试机制
- 自定义进度条动画效果 