# 游戏广场界面设置说明

## 概述
这个界面实现了一个游戏广场，显示8个游戏卡片的横滑列表，每个卡片包含游戏缩略图和标题。

## 节点结构

### 1. 主要节点层级
```
Canvas (1920x1080)
├── bg (背景 - 浅色背景)
├── back_btn (返回按钮 - 左上角)
├── header (标题栏)
│   └── title_label (游戏广场标题)
└── game_list_container (游戏列表容器)
    └── scroll_view (滚动视图)
        └── content (内容节点 - 包含所有游戏卡片)
```

### 2. 游戏卡片结构
```
game_card (300x400)
├── card_bg (卡片背景 - 白色圆角矩形)
├── game_thumbnail (游戏缩略图 - 260x280)
└── game_title (游戏标题 - 280x60)
```

## 在Cocos Creator中的设置步骤

### 步骤1: 创建主要节点
1. 在Canvas下创建以下节点：
   - `bg` (Sprite) - 设置浅色背景
   - `back_btn` (Button) - 返回按钮，已存在
   - `header` (Node) - 标题栏容器
   - `game_list_container` (Node) - 游戏列表容器

### 步骤2: 设置标题栏
1. 在`header`节点下创建：
   - `title_label` (Label) - 设置文本为"游戏广场"
   - 字体大小：32，颜色：黑色
   - 位置：居中显示

### 步骤3: 设置滚动视图
1. 在`game_list_container`下创建：
   - `scroll_view` (ScrollView组件)
   - 设置ScrollView属性：
     - Content: 创建content子节点
     - Horizontal: true (允许水平滚动)
     - Vertical: false (禁用垂直滚动)
     - Elastic Top/Bottom: 0
     - Elastic Left/Right: 0.1

### 步骤4: 设置内容节点
1. 在`scroll_view`下创建`content`节点
2. 设置content节点属性：
   - Anchor Point: (0, 0.5)
   - Position: (0, 0)

### 步骤5: 创建游戏卡片预制体（推荐）
1. 创建新的预制体文件：`game-card.prefab`
2. 在预制体中创建卡片结构：
   - 根节点：300x400
   - `card_bg`: 白色背景，300x400
   - `game_thumbnail`: 缩略图容器，260x280，位置(0, 60)
   - `game_title`: 标题标签，280x60，位置(0, -160)
3. 添加`GameCard`组件到根节点
4. 在组件中绑定对应的属性引用

### 步骤6: 配置脚本组件
1. 在Canvas节点上添加`GameCenter`脚本组件
2. 在脚本组件中设置属性：
   - `gameListContainer`: 拖拽`game_list_container`节点
   - `gameCardPrefab`: 拖拽`game-card.prefab`预制体
   - `scrollView`: 拖拽`scroll_view`节点

## 样式设置

### 颜色方案
- 背景色：浅色 (#F8F6EF)
- 卡片背景：白色 (#FFFFFF)
- 标题文字：黑色 (#000000)

### 尺寸规格
- 卡片尺寸：300x400
- 卡片间距：30px
- 缩略图尺寸：260x280
- 标题区域：280x60

### 字体设置
- 标题字体：24px
- 行高：30px
- 对齐方式：居中对齐

## 功能特性

1. **自动加载游戏数据**：从API接口获取游戏列表
2. **动态创建卡片**：根据数据自动生成游戏卡片
3. **横滑滚动**：支持触摸滑动浏览所有游戏
4. **点击交互**：每个卡片都可以点击，触发相应事件
5. **响应式布局**：自动计算内容宽度，适配不同数量的游戏

## 注意事项

1. 确保网络接口正常工作，能够获取游戏数据
2. 游戏封面图片需要能够正常加载
3. 如果使用预制体，确保路径和引用正确
4. 滚动视图的content节点大小会根据游戏数量自动调整
5. 建议在真机上测试触摸滑动效果

## 扩展功能

1. **搜索功能**：可以添加搜索框过滤游戏
2. **分类功能**：按游戏类型分组显示
3. **收藏功能**：允许用户收藏喜欢的游戏
4. **最近游戏**：显示最近玩过的游戏
5. **游戏统计**：显示游戏完成度等信息 