import {Component, ElementRef, ViewChild, OnInit, Input, OnDestroy, HostListener} from '@angular/core';

import {
  getAngleByPos,
  MySprite,
  getPosByAngle,
  Label,
  MyAnimation,
  moveItem,
  randomSortByArr,
  scaleItem,
  rotateItem,
  tweenChange,
  hideItem,
  showItem,
  BitMapLabel,
  ColorSpr,
  removeItemFromArr,
  ShapeRect,
  alphaItem,
  circleMove,
  ShapeCircle,
  delayCall,
  RichText,
  getMinScale,
  getPosDistance, jelly, showPopParticle, shake
} from './Unit';
import {res, resAudio} from './resources';

import {Subject} from 'rxjs';
import {debounceTime} from 'rxjs/operators';

import * as _ from 'lodash';
import TWEEN from '@tweenjs/tween.js';
import {del} from 'selenium-webdriver/http';
import {text} from "@angular/core/src/render3";


@Component({
  selector: 'app-play',
  templateUrl: './play.component.html',
  styleUrls: ['./play.component.scss']
})
export class PlayComponent implements OnInit, OnDestroy {
  // 数据
  _data;

  @Input()
  set data(data) {
    this._data = data;
  }
  get data() {
    return this._data;
  }

  @Input()
  sid;

  @ViewChild('canvas') canvas: ElementRef;
  @ViewChild('wrap') wrap: ElementRef;
  canvasWidth = 1280;
  canvasHeight = 720;

  canvasBaseW = 1280;
  canvasBaseH = 720;

  ctx;
  fps = 0;
  frametime = 0;  // 上一帧动画的时间，   两帧时间差


  mx;
  my; // 点击坐标



  // 资源
  rawImages = new Map(res);
  rawAudios = new Map(resAudio);

  // 声音

  bgAudio = new Audio();
  successAudio = new Audio();
  wrongAudio = new Audio();
  rightAudio = new Audio();
  titleAudio = new Audio();


  images = new Map();

  animationId: any;
  winResizeEventStream = new Subject();


  audioObj = {};
  renderArr;
  mapScale = 1;

  canvasLeft;
  canvasTop;


  canTouch = true;


  KEY = 'hw_004';

  // -----
  picArr;
  itemArrA;
  itemArrB;
  curItem;
  linkIdArr;
  petalTime;


  itemBgArr;
  ballArr;
  lightIndex = 0;
  grouoLightIndex = 0;
  curLight;
  goBtn;
  wheel;
  arrow;
  lightDelayTime = 0;
  questionBg;
  answerLabelArr;
  questionLabel;
  questionLabel2;
  questionPicRect;
  textBgArr;
  picBgArr;
  answerPicArr;
  idArr;
  answerTypeArr = ['A', 'B', 'C', 'D'];
  answerTitleArr;
  lightDelayId;
  rightFlag;
  ballGroupArr;
  animaStopRun;
  animaNewStopRun;


  hotZoneArr;
  picRect;
  closeBtn;
  itemBg;
  curSong;



  oldFrameColorId;
  curCard;
  bottomCard;


  picW = 370;
  picH = 260;
  mask;
  ball;
  stick;
  robot;



  pageW = 840;
  page1;
  page2;
  arm1;
  arm2;
  centerPageArr;
  pageOffX = 100;
  curPic;



  roleArr;
  picIndex = 0;
  curData;
  bgTop;
  topImg;
  curWordArr;
  wordMoveFlag;
  maxScore;
  bottomY;
  leftScore;
  rightScore;
  leftScoreLabel;
  rightScoreLabel;
  addScoreNum = 20;
  leftWin;
  rightWin;
  startPageArr = [];



  bgArr;
  rightArr;

  title;


  startBtn;
  starArr;

  wand;

  light;
  replayBtn;
  endPageArr;
  gameEndFlag;
  showPetalFlag;
  bg;




  @HostListener('window:resize', ['$event'])
  onResize(event) {
    this.winResizeEventStream.next();
  }


  ngOnInit() {


    const getData = (<any> window).courseware.getData;
    getData((data) => {

      if (data && typeof data == 'object') {
        this.data = data;
      } else {
        this.data = {};
      }

      console.log('data:' , data);
      if (!this.data.contentObj) {
        this.data.contentObj = {};
      }

      this.initDefaultData();



      this.initAudio();
      this.initImg();
      this.initListener();

    }, this.KEY);


    //
    // // this.initAudio();
    // this.initImg();
    // this.initListener();
  }





  initDefaultData() {


    const picArr = this.data.contentObj.picArr;
    // console.log('picArr: ', picArr);
    if (!picArr || picArr.length == 0) {

      const picArr = [];
      for (let i = 0; i < 4; i ++) {

        const data = {
          a_text: (i + 1),
          a_audio_url: "",
          a_pic_url: "",
          b_text: '0' + (i + 1),
          b_audio_url: "",
          b_pic_url: "",
        };

        if (i == 0) {
          data.a_pic_url = 'assets/play/default/item.png';
          data.b_pic_url = 'assets/play/default/item.png';
        }

        picArr.push(data);
      }

      this.data.contentObj.picArr = picArr;

    }


  }

  ngOnDestroy() {
    window['curCtx'] = null;
    window.cancelAnimationFrame(this.animationId);
    this.bgAudio.pause();
    this.gameEndFlag = true;
    clearTimeout(this.lightDelayId);
  }

  initData() {

    this.canvasWidth = this.wrap.nativeElement.clientWidth;
    this.canvasHeight = this.wrap.nativeElement.clientHeight;

    this.canvas.nativeElement.width = this.wrap.nativeElement.clientWidth;
    this.canvas.nativeElement.height = this.wrap.nativeElement.clientHeight;


    const sx = this.canvasWidth / this.canvasBaseW;
    const sy = this.canvasHeight / this.canvasBaseH;
    const s = Math.min(sx, sy);
    this.mapScale = s;

    // this.mapScale = this.canvasWidth / this.canvasBaseW;
    // this.mapScale = this.canvasHeight / this.canvasBaseH;
    this.renderArr = [];

    console.log(' in initData', this.data);






    this.canTouch = true;
    this.renderArr = [];
    this.endPageArr = [];

    if (!this.data.contentObj.picArr) {
      this.data.contentObj.picArr = [];
    }
    this.picArr = this.data.contentObj.picArr;
    // this.picArr = randomSortByArr(this.picArr);
    //
    // // this.picArr = randomSortByArr(this.picArr);
    // this.picIndex = 0;
    //


    for (let i = 0; i < this.picArr.length; i++) {
      const data = this.picArr[i];

      if (!data.optionTypeA) {
        if (data.a_pic_url) {
          data.optionTypeA = 'B';
        } else {
          data.optionTypeA = 'A';
        }
      }

      if (!data.optionTypeB) {
        if (data.b_pic_url) {
          data.optionTypeB = 'B';
        } else {
          data.optionTypeB = 'A';
        }
      }
    }

  }





  initAudio() {

    const contentObj = this.data.contentObj;
    if (!contentObj) { return; }



    // const addAudio = (key) => {
    //   const audioUrl = contentObj[key];
    //   if (audioUrl) {
    //     const audio = new Audio();
    //     audio.src = audioUrl;
    //     audio.load();
    //     this.audioObj[key] = audio;
    //   }
    // }
    //
    // for (let i = 0; i < 4; i ++) {
    //   const key = i + '_audio_url';
    //   addAudio(key);
    // }
    //
    // addAudio('audio_url');
    //


    const addUrlToAudioObj = (audioUrl) => {

      if (audioUrl) {

        // console.log('audioUrl:', audioUrl);
        const audio = new Audio();
        audio.src = audioUrl;
        audio.load();
        this.audioObj[audioUrl] = audio;
      }
    };


    const arr = contentObj.picArr;

    if (arr) {
      // console.log('arr: ', arr);
      for (let i = 0; i < arr.length; i++) {
        addUrlToAudioObj(arr[i].a_audio_url);
        addUrlToAudioObj(arr[i].b_audio_url);
      }
    }




    const audioObj = this.audioObj;
    const addOneAudio = (key, url, vlomue = 1, loop = false, callback = null) => {

      const audio = new Audio();
      audio.src = url;
      audio.load();
      audio.loop = loop;
      audio.volume = vlomue;

      audioObj[key] = audio;

      if (callback) {
        audio.onended = () => {
          callback();
        };
      }
    };


    addOneAudio('click', this.rawAudios.get('click'), 1);
    addOneAudio('line', this.rawAudios.get('line'), 0.4);
    addOneAudio('star', this.rawAudios.get('star'), 1);
    addOneAudio('wrong', this.rawAudios.get('wrong'), 1);
    addOneAudio('finish', this.rawAudios.get('finish'), 1);



    //
    // const titleUrl = this.data.contentObj.title_audio_url;
    // if (titleUrl) {
    //
    //   this.titleAudio.src = titleUrl;
    //   this.titleAudio.load();
    // }



    // this.bgAudio.src = 'assets/bat-mail/music/bg.mp3';
    // this.bgAudio.load();
    // this.bgAudio.loop = true;
    // this.bgAudio.volume = 0.5;
    //
    // this.wrongAudio.src = 'assets/common/music/wrong.mp3';
    // this.wrongAudio.load();
    //
    // this.rightAudio.src = 'assets/common/music/right.mp3';
    // this.rightAudio.load();
    //
    // this.successAudio.src = 'assets/magic-hat/music/finish.mp3';
    // this.successAudio.load();
    //
    // this.successAudio.onended = () => {
    //   // this.showSuccessAudio();
    // };


  }

  initImg() {

    const contentObj = this.data.contentObj;
    if (contentObj) {


      const addPicUrl = (url) => {
        if (url) {
            this.rawImages.set(url, url);
          }
      };


      const arr = this.data.contentObj.picArr;
      if (arr) {

        for (let i = 0; i < arr.length; i++) {
          addPicUrl( arr[i].a_pic_url);
          addPicUrl( arr[i].b_pic_url);

        }
      }

    }


    // this.initFontImg();



    // 预加载资源

    this.loadResources().then(() => {
      // this.setfontData();

      window['air'].hideAirClassLoading(this.KEY, this.data);

      this.init();
      this.update();
    });

  }

  initFontImg() {



    // const fontbaseUrlW = 'assets/mechanical/letter/';
    // const fontDataW = {};
    //
    // let num = 97;
    // for (let i = 0; i < 26; i++) {
    //
    //   const key = String.fromCharCode(num + i);  // 'a'
    //   const url = fontbaseUrlW + key + '.png';
    //
    //   this.rawImages.set(url, url);
    //   fontDataW[key] = url;
    // }
    //
    //
    // this.fontDataW = fontDataW;
  }

  setfontData() {

    // for (let key in this.fontDataW) {
    //   this.fontDataW[key] = this.images.get(this.fontDataW[key]);
    // }
  }








  init() {

    this.initData();
    this.initCtx();

    this.initView();


  }

  initCtx() {

    this.ctx = this.canvas.nativeElement.getContext('2d');
    this.canvas.nativeElement.width = this.canvasWidth;
    this.canvas.nativeElement.height = this.canvasHeight;

    window['curCtx'] = this.ctx;


    // console.log('this.ctx.canvas w: ', this.ctx.canvas.width);
    // console.log('this.ctx.canvas h: ', this.ctx.canvas.height);
  }


  initView() {

    this.initBg();

    this.initItem();
    // this.initWheel();
    //
    // this.showStartAnima();
    //
    // this.initLightAnimaNew();
    //
    // this.initQuestionWindow();
    //
    // this.playAudio('bg');
  }


  initItem() {


    const picArr = this.picArr;

    let itemW, edgeW, disW, disH, offX, offY;

    if (picArr.length <= 6) {

      itemW = 215 * this.mapScale;
      edgeW = 10 * this.mapScale;
      disW = (this.canvasWidth - itemW * 6 - edgeW * 2) / 5;
      disH = 300 * this.mapScale;

      offX = this.canvasWidth / 2 - (picArr.length - 1) * (itemW + disW) / 2;
      offY = this.canvasHeight / 2 - disH / 2 + 70 * this.mapScale;
    } else {


      // itemW = 215 * this.mapScale;
      const rate = 10; // 距离与图片比例 10：1
      edgeW = 10 * this.mapScale;
      itemW = (this.canvasWidth - edgeW / 2) / (picArr.length * rate + picArr.length + 1) * rate;
      disW = itemW / rate;
      disH = 300 * this.mapScale;

      offX = this.canvasWidth / 2 - (picArr.length - 1) * (itemW + disW) / 2;
      offY = this.canvasHeight / 2 - disH / 2 + 70 * this.mapScale;
    }

    const tmpS = itemW / 215;
    const rectW = 157 * tmpS;



    let dataArrA = [];
    let dataArrB = [];
    for (let i = 0; i < picArr.length; i ++) {
      const picData = picArr[i];

      let tmpData = {};
      tmpData['id'] = i;
      tmpData['text'] = picData.a_text;
      tmpData['pic_url'] = picData.a_pic_url;
      tmpData['audio_url'] = picData.a_audio_url;
      tmpData['optionType'] = picData.optionTypeA;
      dataArrA.push(tmpData);

      tmpData = {};
      tmpData['id'] = i;
      tmpData['text'] = picData.b_text;
      tmpData['pic_url'] = picData.b_pic_url;
      tmpData['audio_url'] = picData.b_audio_url;
      tmpData['optionType'] = picData.optionTypeB;
      dataArrB.push(tmpData);
    }

    dataArrA = randomSortByArr(dataArrA);
    dataArrB = randomSortByArr(dataArrB);

    // this.itemArrA = itemArrA;
    // this.itemArrB = itemArrB;



    this.itemArrA = [];
    this.itemArrB = [];
    for (let i = 0; i < picArr.length; i ++) {


      const dataA = dataArrA[i];

      let itemBg = new MySprite();
      itemBg.init(this.images.get('item_bg'));
      itemBg.setScaleXY(itemW / itemBg.width);
      itemBg.x = offX + i * (itemW + disW);
      itemBg.y = offY;

      let bgRect = new ShapeRect();
      // bgRect.setSize(rectW, rectW);
      bgRect.setSize(157, 157);
      bgRect.init();
      // bgRect.x = itemBg.x;
      // bgRect.y = itemBg.y;
      bgRect.fillColor = '#ffffff';
      itemBg.addChild(bgRect, -1);
      // this.renderArr.push(bgRect);

      if (dataA.optionType == 'B') {
        let pic = new MySprite();
        pic.init(this.images.get(dataA.pic_url));
        pic.setScaleXY(getMinScale(pic, bgRect.width - 2));
        bgRect.addChild(pic);
      } else {
        const label = new Label();
        label.text = dataA.text;
        label.fontName = 'BRLNSDB';
        label.textAlign = 'center';
        label.fontSize = 64;
        label.setMaxSize(bgRect.width - 20);

        bgRect.addChild(label);
      }

      let dot = new MySprite();
      dot.init(this.images.get('dot'));
      dot.y = itemBg.height / 2 - 25;
      dot.visible = false;
      itemBg.addChild(dot);

      itemBg['dot'] = dot;
      itemBg['type'] = 'A';
      itemBg['data'] = dataA;
      this.renderArr.push(itemBg);
      this.itemArrA.push(itemBg);




      const dataB = dataArrB[i];
      itemBg = new MySprite();
      itemBg.init(this.images.get('item_bg'));
      itemBg.setScaleXY(itemW / itemBg.width);
      itemBg.x = offX + i * (itemW + disW);
      itemBg.y = offY + disH;


      bgRect = new ShapeRect();
      // bgRect.setSize(rectW, rectW);
      bgRect.setSize(157, 157);
      bgRect.init();
      // bgRect.x = itemBg.x;
      // bgRect.y = itemBg.y;
      bgRect.fillColor = '#ffffff';
      itemBg.addChild(bgRect, -1);
      // this.renderArr.push(bgRect);

      if (dataB.optionType == 'B') {
        let pic = new MySprite();
        pic.init(this.images.get(dataB.pic_url));
        pic.setScaleXY(getMinScale(pic, bgRect.width - 2));
        bgRect.addChild(pic);
      } else {
        const label = new Label();
        label.text = dataB.text;
        label.fontName = 'BRLNSDB';
        label.textAlign = 'center';
        label.fontSize = 64;
        label.setMaxSize(bgRect.width - 20);

        bgRect.addChild(label);
      }

      dot = new MySprite();
      dot.init(this.images.get('dot'));
      dot.y = -itemBg.height / 2 + 25;
      dot.visible = false;
      itemBg.addChild(dot);

      itemBg['dot'] = dot;
      itemBg['type'] = 'B';
      itemBg['data'] = dataB;
      this.renderArr.push(itemBg);
      this.itemArrB.push(itemBg);
    }
  }

  showStartAnima() {

    const go = new MySprite(this.ctx);
    go.init(this.images.get('go'));
    go.setScaleXY(this.mapScale);
    go.x = this.canvasWidth + go.width * go.scaleX;
    go.y = this.canvasHeight - go.height / 2 * go.scaleY - 30 * this.mapScale;
    this.renderArr.push(go);
    this.goBtn = go;

    const targetX = this.canvasWidth - go.width / 2 * go.scaleX - 30 * this.mapScale;
    moveItem(go, targetX, go.y, 0.7, () => {

    }, TWEEN.Easing.Cubic.Out);

    this.playAudio('enter');

  }


  initLightAnima() {


    clearTimeout(this.lightDelayId);

    if (this.animaStopRun) {
      return;
    }


    const delayTime = this.lightDelayTime;


    // delayCall(delayTime, () => {

    this.lightDelayId = setTimeout(() => {

      if (this.animaStopRun) {
        return;
      }

      if (this.curLight) {
        hideItem(this.curLight, 0.02, null, TWEEN.Easing.Cubic.Out);
      }

      this.curLight = this.ballArr[this.lightIndex].light;

      showItem(this.curLight, 0.02, () => {
        this.initLightAnima();
      }, TWEEN.Easing.Cubic.Out);

      this.lightIndex--;
      if (this.lightIndex < 0) {
        this.lightIndex = this.ballArr.length - 1;
      }
      // });
    }, delayTime * 1000);
  }

  initLightAnimaNew() {

    // console.log(' in initLightAnimaNew');

    clearTimeout(this.lightDelayId);

    if (this.animaNewStopRun) {
      return;
    }


    const delayTime = this.lightDelayTime;
    // delayCall(delayTime, () => {

    this.lightDelayId = setTimeout(() => {
      // if (this.curLight) {
      //   hideItem(this.curLight, 0.02, null, TWEEN.Easing.Cubic.Out);
      // }
      //

      if (this.animaNewStopRun) {
        return;
      }

      this.lightDelayTime = 1;

      for (let i = 0; i < this.ballGroupArr.length; i++) {
        if (i != this.grouoLightIndex) {
          const arr = this.ballGroupArr[i].arr;
          for (let j = 0; j < arr.length; j++) {
            hideItem(arr[j], 0.02);
          }
        }
      }

      // this.curLight = this.ballArr[this.lightIndex].light;

      const lightArr = this.ballGroupArr[this.grouoLightIndex].arr;
      for (let i = 0; i < lightArr.length; i++) {

        if (i == lightArr.length - 1) {
          showItem(lightArr[i], 0.02, () => {
            this.initLightAnimaNew();
          }, TWEEN.Easing.Cubic.Out);
        } else {
          showItem(lightArr[i], 0.02, () => {
          }, TWEEN.Easing.Cubic.Out);
        }
      }

      // showItem(this.curLight, 0.02, () => {
      //   this.initLightAnima();
      // }, TWEEN.Easing.Cubic.Out);


      this.grouoLightIndex--;
      if (this.grouoLightIndex < 0) {
        this.grouoLightIndex = this.ballGroupArr.length - 1;
      }

      // this.lightIndex--;
      // if (this.lightIndex < 0) {
      //   this.lightIndex = this.ballArr.length - 1;
      // }
      // });
    }, delayTime * 1000);



  }




  initQuestionWindow() {

    const mask = new ShapeRect(this.ctx);
    mask.setSize(this.canvasWidth, this.canvasHeight);
    mask.fillColor = '#000000';
    mask.alpha = 0.7;
    mask.visible = false;

    this.mask = mask;



    const bg = new MySprite(this.ctx);
    bg.init(this.images.get('question_bg'));
    bg.setScaleXY(this.mapScale);
    bg.x = this.canvasWidth / 2;
    bg.y = this.canvasHeight / 2;
    mask.addChild(bg);
    this.questionBg = bg;


    const w = 1020;
    const h = 230;
    const w2 = 740;

    const labelRect1 = new ShapeRect(this.ctx);
    labelRect1.setSize(w2, h);
    labelRect1.alpha = 0;
    labelRect1.x = -bg.width / 2 + 75;
    labelRect1.y = -bg.height / 2 + 60;
    bg.addChild(labelRect1);

    const richText = new RichText(this.ctx);
    richText.text = '';
    richText.disH = 0;
    richText.fontName = 'RoundedBold';
    richText.width = w2;
    richText.x = labelRect1.x; // + labelRect1.width / 2;
    richText.y = labelRect1.y + labelRect1.height / 2 - richText.fontSize / 2;
    richText.fontSize = 48;
    bg.addChild(richText);
    this.questionLabel = richText;

    const picRect = new ShapeRect(this.ctx);
    picRect.setSize(h, h);
    picRect.alpha = 0;
    picRect.x = labelRect1.x + w - picRect.width;
    picRect.y = labelRect1.y;
    bg.addChild(picRect);
    this.questionPicRect = picRect;

    // const labelRect2 = new ShapeRect(this.ctx);
    // labelRect2.setSize(w, h);
    // labelRect2.alpha = 0.3;
    // labelRect2.x = labelRect1.x;
    // labelRect2.y = labelRect1.y;
    // bg.addChild(labelRect2);

    const richText2 = new RichText(this.ctx);
    richText2.text = '';
    richText2.disH = 0;
    richText2.fontName = 'RoundedBold';
    richText2.width = w;
    richText2.x = labelRect1.x; // + labelRect1.width / 2;
    richText2.y = labelRect1.y + labelRect1.height / 2 - richText.fontSize / 2;
    richText2.fontSize = 48;
    bg.addChild(richText2);
    this.questionLabel2 = richText2;


    const textBgH = 81;
    const disH = 5;
    const offX = labelRect1.x;
    const offY = labelRect1.y + labelRect1.height + textBgH / 2 + 15;

    this.textBgArr = [];
    this.answerLabelArr = [];
    const keyArr = ['a', 'b', 'c', 'd'];
    for (let i = 0; i < 4; i++) {
      const key = 'text_bg_' + keyArr[i];
      const textBg = new MySprite(this.ctx);
      textBg.init(this.images.get(key));
      textBg.x = offX + textBg.width / 2;
      textBg.y = offY + i * (textBgH + disH);
      bg.addChild(textBg, 2);
      this.textBgArr.push(textBg);

      const label = new Label(this.ctx);
      label.fontName = 'RoundedBold';
      label.text = 'aaaaaaaa';
      label.fontColor = '#000000';
      // label.textAlign = 'center';
      label.fontSize = 50;
      label.setMaxSize(textBg.width - 230);
      label.refreshSize();
      label.x = -textBg.width / 2 + 90;
      textBg.addChild(label);

      const rightBg = new MySprite(this.ctx);
      rightBg.init(this.images.get('text_right'));
      rightBg.x = textBg.x;
      rightBg.y = textBg.y;
      bg.addChild(rightBg, 1);
      rightBg.visible = false;
      textBg['rightBg'] = rightBg;

      const wrongBg = new MySprite(this.ctx);
      wrongBg.init(this.images.get('text_wrong'));
      wrongBg.x = textBg.x;
      wrongBg.y = textBg.y;
      bg.addChild(wrongBg, 1);
      wrongBg.visible = false;
      textBg['wrongBg'] = wrongBg;

      this.answerLabelArr.push(label);

    }


    this.picBgArr = [];
    this.answerTitleArr = [];
    const picBgW = 236;
    const disW = (w - picBgW * 4) / 3;
    for (let i = 0; i < 4; i ++) {
      const key = 'pic_bg_' + keyArr[i];
      const picBg = new MySprite(this.ctx);
      picBg.init(this.images.get(key));
      picBg.x = offX + picBg.width / 2 + i * (picBgW + disW);
      picBg.y = offY + picBg.height / 2 - textBgH / 2;
      bg.addChild(picBg);
      this.picBgArr.push(picBg);


      const rightBg = new MySprite(this.ctx);
      rightBg.init(this.images.get('pic_right'));
      rightBg.x = picBg.x;
      rightBg.y = picBg.y;
      bg.addChild(rightBg, 1);
      rightBg.visible = false;
      picBg['rightBg'] = rightBg;

      const wrongBg = new MySprite(this.ctx);
      wrongBg.init(this.images.get('pic_wrong'));
      wrongBg.x = picBg.x;
      wrongBg.y = picBg.y;
      bg.addChild(wrongBg, 1);
      wrongBg.visible = false;
      picBg['wrongBg'] = wrongBg;


      const textKey = 'text_' + keyArr[i];
      const title = new MySprite(this.ctx);
      title.init(this.images.get(textKey));
      title.x = picBg.x;
      title.y = picBg.y - picBg.height / 2 + 39;
      bg.addChild(title);
      this.answerTitleArr.push(title);

    }


    this.hideArr(this.textBgArr);





    const closeBtn = new MySprite(this.ctx);
    closeBtn.init(this.images.get('close_btn'));
    bg.addChild(closeBtn);
    closeBtn.x = bg.width / 2 - 25;
    closeBtn.y = -bg.height / 2 + 50;
    this.closeBtn = closeBtn;




  }


  initItemView() {

  }



  initHotZone() {


    let curBgRect;
    if (this.bg) {
      curBgRect = this.bg.getBoundingBox();
    }

    let oldBgRect = this.data.contentObj.bgItem.rect;
    if (!oldBgRect) {
      oldBgRect = curBgRect;
    }

    const rate = curBgRect.width / oldBgRect.width;


    // this.imgArr = [];
    // const arr = this.data.contentObj.imgItemArr;
    this.hotZoneArr = [];
    const arr = this.data.contentObj.hotZoneItemArr;
    if (!arr) return;

    for (let i = 0; i < arr.length; i++) {

      const data = JSON.parse(JSON.stringify(arr[i]));
      // const img = {pic_url: data.pic_url};

      data.rect.x *= rate;
      data.rect.y *= rate;
      data.rect.width *= rate;
      data.rect.height *= rate;

      data.rect.x += curBgRect.x;
      data.rect.y += curBgRect.y;

      const hotZone = this.getHotZoneItem(data);
      hotZone.alpha = 0;
      this.hotZoneArr.push(hotZone);
      // hotZone['audio'] = this.audioObj[data.audio_url];
      // this.imgArr.push(img);
    }


    //
    //
    // const hotZoneItemArr = this.data.contentObj.hotZoneItemArr;
    // if (!hotZoneItemArr) {
    //   return;
    // }
    //
    // if (!this.bg) {
    //   return;
    // }
    //
    // const bgRect = this.bg.getBoundingBox();
    // const bgItem = this.data.contentObj.bgItem;
    //
    // const rate = bgRect.width / bgItem.rect.width;
    //
    //
    // for (let i = 0; i < hotZoneItemArr.length; i++) {
    //
    //   const tmpData = hotZoneItemArr[i];
    //   const shapeRect = new ShapeRect(this.ctx);
    //   shapeRect.anchorX = 0;
    //   shapeRect.anchorY = 0;
    //   shapeRect.setSize(tmpData.rect.width, tmpData.rect.height);
    //   shapeRect.setScaleXY(this.bg.scaleX);
    //   shapeRect.x = (bgItem.rect.x - bgRect.x + tmpData.rect.x ) / rate;
    //   shapeRect.y = (bgItem.rect.y - bgRect.y + tmpData.rect.y ) / rate;
    //
    //   // shapeRect.x = tmpData.rect.x - this.bg.width / 2;
    //   // shapeRect.y = tmpData.rect.y - this.bg.height / 2;
    //   // this.bg.addChild(shapeRect);
    //
    //   this.renderArr.push(shapeRect);
    // }


  }



  getHotZoneItem(data) {
    const saveRect = data.rect;
    const item = new ShapeRect(this.ctx);
    item.setSize(saveRect.width, saveRect.height);
    item.x = saveRect.x ;
    item.y = saveRect.y ;
    item['data'] = data;

    this.renderArr.push(item);

    // console.log('data: ', data);


    return item;
  }





  initCard() {

    const card = new MySprite(this.ctx);
    card.init(this.images.get(this.getFrameColor()));
    card.setScaleXY(this.mapScale);
    card.x = this.canvasWidth / 2;
    card.y = this.canvasHeight / 2;
    this.addPic(card);

    this.renderArr.push(card);

    this.curCard = card;

    this.addBottomCard();

  }

  getFrameColor() {
    let arr = ['1', '2', '3'];
    if (this.oldFrameColorId) {
      removeItemFromArr(arr, this.oldFrameColorId);
    }

    arr = randomSortByArr(arr);
    const colorId = arr[0];
    this.oldFrameColorId = colorId;
    return 'frame_' + colorId;
  }

  addPic(card) {



    const curData = this.picArr[this.picIndex];

    const w = 340;
    const h = 340;
    const pic = new MySprite(this.ctx);
    pic.init(this.images.get(curData.pic_url));
    const sx = w / pic.width;
    const sy = h / pic.height;
    const s = Math.min(sx, sy);
    pic.setScaleXY(s);

    pic.x = 5;
    card.addChild(pic);

    card.data = curData;


    this.picIndex ++;
    if (this.picIndex >= this.picArr.length) {
      this.picIndex = 0;
    }
  }


  initRobot() {
    const robot = new MySprite(this.ctx);
    robot.init(this.images.get('robot'));
    robot.setScaleXY(this.mapScale);
    robot.x = this.canvasWidth / 2 - 50 * this.mapScale;
    robot.y = this.canvasHeight / 2 + 50 * this.mapScale;
    this.renderArr.push(robot);
    this.robot = robot;

    const stick = new MySprite(this.ctx);
    stick.init(this.images.get('stick'));
    stick.anchorY = 0.95;
    stick.x = robot.width / 2 + stick.width / 2 - 5;
    stick.y = -25;
    robot.addChild(stick);
    this.stick = stick;

    const ball = new MySprite(this.ctx);
    ball.init(this.images.get('ball'));
    ball.x = stick.x;
    ball.y = stick.y - stick.height;
    robot.addChild(ball);
    this.ball = ball;


    const mask = new MySprite(this.ctx);
    mask.init(this.images.get('mask'));
    mask.x = 31;
    mask.y = 2;
    robot.addChild(mask);
    this.mask = mask;

    // const w = 800;
    // const h = 260;
    // const rect = new ShapeRect(this.ctx);
    // rect.setSize(w, h);
    // rect.anchorX = 0.5;
    // rect.anchorY = 0.5;
    // mask.addChild(rect);



  }





  initBg() {

    this.bgArr = [];

    const bg = new MySprite();
    bg.init(this.images.get('bg'));
    bg.x = this.canvasWidth / 2;
    bg.y = this.canvasHeight / 2;
    const sx = this.canvasWidth / bg.width;
    const sy = this.canvasHeight / bg.height;
    const s = Math.max(sx, sy);
    bg.setScaleXY(s);
    this.bgArr.push(bg);


    const title = new MySprite();
    title.init(this.images.get('title'));
    title.setScaleXY(this.mapScale);
    title.x = this.canvasWidth / 2;
    title.y = this.canvasHeight / 2 - 270 * this.mapScale;
    this.bgArr.push(title);

  }

  initWheel() {
    //
    // const wheelBottom = new MySprite(this.ctx);
    // wheelBottom.init(this.images.get('wheel_bottom'));
    // wheelBottom.x = this.canvasWidth / 2;
    // wheelBottom.y = this.canvasHeight / 2;
    // wheelBottom.setScaleXY(this.mapScale);
    // this.renderArr.push(wheelBottom);
    //
    //
    // const num = this.picArr.length;
    // const colorArr = ['#efd303', '#f0b904', '#ef9303'];
    // const len = wheelBottom.width / 2 * wheelBottom.scaleX * 0.78;
    // const wheel = new Wheel(this.ctx);
    // wheel.initWheel(num, len, colorArr);
    // wheel.x = wheelBottom.x;
    // wheel.y = wheelBottom.y - 5;
    // this.renderArr.push(wheel);
    // this.wheel = wheel;
    //
    //
    // const arrow = new MySprite(this.ctx);
    // arrow.init(this.images.get('arrow'));
    // arrow.setScaleXY(this.mapScale);
    // arrow.x = wheel.x;
    // arrow.y = wheel.y;
    // this.renderArr.push(arrow);
    // this.arrow = arrow;
    // arrow['baseY'] = arrow.y;
    //
    //
    // const wheelTop = new MySprite(this.ctx);
    // wheelTop.init(this.images.get('wheel_top'));
    // wheelTop.setScaleXY(this.mapScale);
    // wheelTop.x = wheel.x;
    // wheelTop.y = wheel.y;
    // this.renderArr.push(wheelTop);
    //
    //
    //
    //
    // const title = new MySprite(this.ctx);
    // title.init(this.images.get('title'));
    // title.setScaleXY(this.mapScale);
    // title.x = (wheelBottom.x - wheelBottom.width / 2 * wheelBottom.scaleX) / 2;
    // title.y = title.height * title.scaleY;
    // this.bgArr.push(title);
    //
    //
    //
    //
    // const addBallLight = (ball, key) => {
    //
    //   const light = new MySprite(this.ctx);
    //   light.init(this.images.get(key + '_light'));
    //   // light.visible = false;
    //   light.alpha = 0;
    //   ball.addChild(light);
    //   ball.light = light;
    //   return light;
    // };
    //
    //
    // this.ballArr = [];
    // let ballId = 1;
    // const ballLen = len * 1.1;
    // const addAngle = Math.round(360 / 16  * 100) / 100;
    // let ballGroupObj = {};
    // for (let i = 0; i < 16; i++) {
    //
    //   const angle = i * addAngle;
    //   const pos = getPosByAngle(angle, ballLen);
    //
    //
    //   const key = 'ball_' + ballId;
    //   const ball = new MySprite(this.ctx);
    //   ball.init(this.images.get(key));
    //   ball.x = wheel.x ; // - 2;
    //   ball.y = wheel.y ; // - 5;
    //   ball.x += pos.x;
    //   ball.y += pos.y;
    //   this.renderArr.push(ball);
    //   // wheelBottom.addChild(ball);
    //   ball.setScaleXY(this.mapScale);
    //   const light = addBallLight(ball, key);
    //   this.ballArr.push(ball);
    //
    //   if (!ballGroupObj[key]) {
    //     ballGroupObj[key] = {};
    //     ballGroupObj[key].id = ballId;
    //     ballGroupObj[key].arr = [];
    //   }
    //   ballGroupObj[key].arr.push(light);
    //
    //
    //   ballId ++;
    //   if (ballId > 4) {
    //     ballId = 1;
    //   }
    // }
    //
    // this.ballGroupArr = [];
    // for (let key in ballGroupObj) {
    //   this.ballGroupArr.push(ballGroupObj[key]);
    // }
    // this.ballGroupArr.sort((a, b) => {
    //   return a.id - b.id;
    // });
    //
    //
    // for (let i = 0; i < this.picArr.length; i++) {
    //
    //   const picData = this.picArr[i];
    //   let pic;
    //   if (picData.pic_url) {
    //     pic = new MySprite(this.ctx);
    //     pic.init(this.images.get(picData.pic_url));
    //   } else {
    //     const label = new Label(this.ctx);
    //     label.text = picData.title;
    //     label.fontName = 'BRLNSDB';
    //     label.fontColor = '#000000';
    //     label.textAlign = 'center';
    //     label.refreshSize();
    //     pic = label;
    //   }
    //
    //   this.wheel.addItem(pic, this.mapScale);
    // }
  }



  resetArm() {
    this.arm1.page1.removeChildren();
    this.arm1.page2.removeChildren();
    this.arm2.page1.removeChildren();
    this.arm2.page2.removeChildren();

    this.arm1.x = this.arm1.baseX;
    this.arm1.y = this.arm1.baseY;

    this.arm2.x = this.arm2.baseX;
    this.arm2.y = this.arm2.baseY;

    this.arm1.page1.visible = true;
    this.arm2.page1.visible = true;
    this.arm1.page2.visible = false;
    this.arm2.page2.visible = false;


    this.picIndex ++ ;
    if (this.picIndex >= this.picArr.length) {
      this.picIndex = 0;

      this.picArr = randomSortByArr(this.picArr);
    }

    this.setPagePoint();
    this.initPic();
  }

  initPic() {

    const w = 370; // * this.mapScale;
    const h = 260;

    const itemBgArr = this.itemBgArr;
    // console.log('picArr:', this.picArr);
    for (let i = 0; i < itemBgArr.length; i++) {

      const itemBg = itemBgArr[i];

      const picData = this.picArr[i];
      if (picData) {
        const picUrl = picData.pic_url;
        // console.log('pirUrl: ', picUrl);
        const pic = new MySprite(this.ctx);
        pic.init(this.images.get(picUrl));
        const sx = w / pic.width;
        const sy = h / pic.height;
        const s = Math.min(sx, sy);
        pic.setScaleXY(s);
        pic.x = -1;
        pic.y = -9;
        itemBg.addChild(pic);
        itemBg['pic'] = pic;
      }


      const iconKey = 'icon_' + (i + 1);
      const icon = new MySprite(this.ctx);
      icon.init(this.images.get(iconKey));
      icon.x = - itemBg.width / 2 + 40;
      icon.y = - itemBg.height / 2 + 40;
      itemBg.addChild(icon);

    }



  }




  initArm() {


    const pageOffX = this.pageOffX;

    const arm1 = new MySprite(this.ctx);
    arm1.init(this.images.get('arm_1_1'), 0, 1);
    arm1.setScaleXY(this.mapScale);
    arm1.x = - arm1.width * arm1.scaleX - this.pageW / 2 * this.mapScale;
    arm1.y = this.canvasHeight + 60 * this.mapScale;
    this.renderArr.push(arm1);

    const page1 = new MySprite(this.ctx);
    page1.init(this.images.get('page_1'), 0);
    page1.x = arm1.width - pageOffX;
    page1.y = - arm1.height + 80;
    arm1.addChild(page1);

    page1.alpha = 1;




    const page1_2 = new MySprite(this.ctx);
    page1_2.init(this.images.get('page_1_2'), 0);
    page1_2.x = page1.x;
    page1_2.y = page1.y;
    page1_2.visible = false;
    arm1.addChild(page1_2);

    arm1['page1'] = page1;
    arm1['page2'] = page1_2;

    arm1['baseX'] = arm1.x;
    arm1['baseY'] = arm1.y;


    const finger = new MySprite(this.ctx);
    finger.init(this.images.get('finger_1_1'), 0, 1);
    arm1.addChild(finger);




    const arm2 = new MySprite(this.ctx);
    arm2.init(this.images.get('arm_2_1'), 1, 1);
    arm2.setScaleXY(this.mapScale);
    arm2.x = this.canvasWidth + arm2.width * arm2.scaleX + this.pageW / 2 * this.mapScale;
    arm2.y = arm1.y;
    this.renderArr.push(arm2);

    const page2 = new MySprite(this.ctx);
    page2.init(this.images.get('page_2'), 1);
    page2.x = -arm2.width + pageOffX;
    page2.y = - arm2.height + 80;
    page2.alpha = 1;
    arm2.addChild(page2);


    const page2_2 = new MySprite(this.ctx);
    page2_2.init(this.images.get('page_2_2'), 1);
    page2_2.x = page2.x;
    page2_2.y = page2.y;
    page2_2.visible = false;
    arm2.addChild(page2_2);

    arm2['baseX'] = arm2.x;
    arm2['baseY'] = arm2.y;

    arm2['page1'] = page2;
    arm2['page2'] = page2_2;


    const finger2 = new MySprite(this.ctx);
    finger2.init(this.images.get('finger_2_1'), 1, 1);
    arm2.addChild(finger2);

    const offX = this.canvasWidth / 2 - this.pageW / 2 * this.mapScale;
    const tx = offX - (arm1.width) * arm1.scaleX + pageOffX * arm1.scaleX;




    // moveItem(arm1, tx, arm1.y);
    //
    // moveItem(arm2, this.canvasWidth - tx, arm2.y);



    this.page1 = page1;
    this.page2 = page2;
    this.arm1 = arm1;
    this.arm2 = arm2;








  }


  setPagePoint() {

    const page1 = this.page1;
    const page2 = this.page2;

    const curData = this.picArr[this.picIndex];
    console.log('this.picArr: ', this.picArr);
    console.log('curData: ', curData);

    if (!curData) {
      return;
    }

    const wordArr1 = curData.wordArr_1;
    const wordArr2 = curData.wordArr_2;


    const centerW = 60;
    const edge = 20;
    const maxW = page1.width - (centerW + edge * 2);

    let num = wordArr1.length;
    let disW = 20;
    let circleW = 68;

    let totalW = edge * 2 + circleW * num + disW * (num - 1);
    let s = 1;
    if (totalW >= maxW) {
      s = maxW / totalW;
      totalW = maxW;
    }

    disW *= s;
    circleW *= s;

    let offX = (maxW - totalW) / 2 + edge + circleW / 2;







    // const disW = (w - circleW * 3) / 4;
    // const offX = disW + circleW / 2;

    for (let i = 0; i < wordArr1.length; i++) {

      const tmpData = wordArr1[i];

      let color = 'green';
      if (tmpData.color) {
        color = tmpData.color;
      }
      const point = new MySprite(this.ctx);
      const key = 'point_' + color;
      point.init(this.images.get(key));
      point.setScaleXY(s);
      point.x = offX + i * (circleW + disW);
      page1.addChild(point);

    }




    num = wordArr2.length;
    disW = 20;
    circleW = 68;

    totalW = edge * 2 + circleW * num + disW * (num - 1);
    s = 1;
    if (totalW >= maxW) {
      s = maxW / totalW;
      totalW = maxW;
    }

    disW *= s;
    circleW *= s;

    offX = (maxW - totalW) / 2 + edge + circleW / 2;

    for (let i = 0; i < wordArr2.length; i++) {

      const tmpData = wordArr2[i];
      let color = 'green';
      if (tmpData.color) {
        color = tmpData.color;
      }
      const point = new MySprite(this.ctx);
      const key = 'point_' + color;
      point.init(this.images.get(key));
      point.setScaleXY(s);
      point.x = (offX + centerW - page2.width) + i * (circleW + disW);
      page2.addChild(point);
    }

  }


  initCenterPage() {

    this.centerPageArr = [];



    const offX = this.canvasWidth / 2 - this.pageW / 2 * this.mapScale;
    const tx = offX - (this.arm1.width) * this.arm1.scaleX + this.pageOffX * this.arm1.scaleX;

    const arm1_2 = new MySprite(this.ctx);
    arm1_2.init(this.images.get('arm_1_2'), 0, 1);
    arm1_2.setScaleXY(this.mapScale);
    arm1_2.x = tx;
    arm1_2.y = this.arm1.y;
    // arm1_2.visible = false;
    this.centerPageArr.push(arm1_2);

    const finger = new MySprite(this.ctx);
    finger.init(this.images.get('finger_1_2'), 0, 1);
    arm1_2.addChild(finger, -2);



    const arm2_2 = new MySprite(this.ctx);
    arm2_2.init(this.images.get('arm_2_2'), 1, 1);
    arm2_2.setScaleXY(this.mapScale);
    arm2_2.x = this.canvasWidth - tx;
    arm2_2.y = this.arm2.y;
    // arm2_2.visible = false;
    this.centerPageArr.push(arm2_2);

    const finger2 = new MySprite(this.ctx);
    finger2.init(this.images.get('finger_2_2'), 1, 1);
    arm2_2.addChild(finger2, -2);


    const centerPage = new MySprite(this.ctx);
    centerPage.init(this.images.get('center_page'), 0);
    centerPage.x = this.page1.x;
    centerPage.y = this.page1.y;
    arm1_2.addChild(centerPage, -1);



    this.hideArr(this.centerPageArr);
    // this.hideArr(this.centerPageArr);

  }








  initStartPage() {

    this.starArr = [];

    const maskLayer = new ShapeRect(this.ctx);
    maskLayer.init(this.images.get(''));
    maskLayer.setSize(this.canvasWidth, this.canvasHeight);
    maskLayer.x = this.canvasWidth / 2;
    maskLayer.y = this.canvasHeight / 2;
    maskLayer.fillColor = '#000000';
    maskLayer.alpha = 0.8;
    this.startPageArr.push(maskLayer);

    const startBtn = new MySprite(this.ctx);
    startBtn.init(this.images.get('start_btn'));
    startBtn.x = this.canvasWidth / 2;
    startBtn.y = this.canvasHeight / 5 * 3;
    startBtn.setScaleXY(this.mapScale);
    this.startPageArr.push(startBtn);
    this.startBtn = startBtn;
  }


  initEndPage() {


    const maskLayer = new ShapeRect(this.ctx);
    maskLayer.init(this.images.get(''));
    maskLayer.setSize(this.canvasWidth, this.canvasHeight);
    maskLayer.x = this.canvasWidth / 2;
    maskLayer.y = this.canvasHeight / 2;
    maskLayer.fillColor = '#000000';
    maskLayer.alpha = 0.8;
    this.endPageArr.push(maskLayer);

    const leftWin = new MySprite(this.ctx);
    leftWin.init(this.images.get('left_win'));
    leftWin.x = this.canvasWidth / 2;
    leftWin.y = this.canvasHeight / 2.5;
    leftWin.setScaleXY(this.mapScale);
    this.endPageArr.push(leftWin);


    const rightWin = new MySprite(this.ctx);
    rightWin.init(this.images.get('right_win'));
    rightWin.x = this.canvasWidth / 2;
    rightWin.y = this.canvasHeight / 2.5;
    rightWin.setScaleXY(this.mapScale);
    this.endPageArr.push(rightWin);

    this.leftWin = leftWin;
    this.rightWin = rightWin;

    // const light = new MySprite(this.ctx);
    // light.init(this.images.get('light_png'));
    // light.x = this.canvasWidth / 2;
    // light.y = this.canvasHeight / 5 * 2;
    // light.setScaleXY(this.mapScale);
    // this.endPageArr.push(light);
    // this.light = light;
    //
    // const hand = new MySprite(this.ctx);
    // hand.init(this.images.get('hand_png'));
    // hand.x = this.canvasWidth / 2;
    // hand.y = light.y;
    // hand.setScaleXY(this.mapScale);
    // this.endPageArr.push(hand);
    // this.hand = hand;

    const replayBtn = new MySprite(this.ctx);
    replayBtn.init(this.images.get('replay_btn'));
    replayBtn.x = this.canvasWidth / 2;
    replayBtn.y = this.canvasHeight / 5 * 3.5;
    replayBtn.setScaleXY(this.mapScale);
    this.endPageArr.push(replayBtn);
    this.replayBtn = replayBtn;


    this.hideArr(this.endPageArr);

    // const lightAction = () => {
    //   light.rotation = 0;
    //   rotateItem(light, 360, 10, () => {
    //     lightAction();
    //   });
    // };
    //
    // lightAction();

  }


  initScore() {


    const addLabelShadow = (label) => {

      const labelShadow = new Label(this.ctx);
      labelShadow.init();
      labelShadow.text = label.text;
      labelShadow.fontSize = label.fontSize;
      labelShadow.fontName = label.fontName;
      labelShadow.fontColor = '#e4688f';
      labelShadow.textAlign = 'center';
      labelShadow.y = 3;
      labelShadow.setShadow(0, 2, 2, 'rgba(154, 23, 58, 0.5)');
      label.addChild(labelShadow, -1);
      label.shadowLabel = labelShadow;

    };

    const labelLeft = new Label(this.ctx);
    labelLeft.init();
    labelLeft.text = '0';
    labelLeft.fontSize = 60;
    labelLeft.fontName = 'BRLNSDB';
    labelLeft.fontColor = '#fef9ff';
    labelLeft.textAlign = 'center';

    labelLeft.x = - this.bgTop.width / 4;
    labelLeft.y = this.bgTop.height / 5;

    labelLeft.refreshSize();

    addLabelShadow(labelLeft);

    this.bgTop.addChild(labelLeft);
    this.leftScoreLabel = labelLeft;




    const labelRight = new Label(this.ctx);
    labelRight.init();
    labelRight.text = '0';
    labelRight.fontSize = 60;
    labelRight.fontName = 'BRLNSDB';
    labelRight.fontColor = '#fef9ff';
    labelRight.textAlign = 'center';

    labelRight.x = this.bgTop.width / 4;
    labelRight.y = this.bgTop.height / 5;

    labelRight.refreshSize();

    addLabelShadow(labelRight);

    this.bgTop.addChild(labelRight);

    this.rightScoreLabel = labelRight;


    // console.log('label.width: ', label.width);
  }







  showEndPage() {

    this.showArr(this.endPageArr);
    this.canTouch = true;
    this.gameEndFlag = true;

    this.showEndPatal();

    this.successAudio.play();

    if (this.leftScore >= this.maxScore) {
      this.rightWin.visible = false;
    } else {
      this.leftWin.visible = false;
    }
  }


  showEndPatal() {

    this.endPageArr = [];
    this.showPetalFlag = true;
    this.addPetal();

  }



  addPetal() {

    if (!this.showPetalFlag) {
      return;
    }

    const petal = this.getPetal();
    this.endPageArr.push(petal);

    moveItem(petal, petal.x, this.canvasHeight + petal.height * petal.scaleY, petal['time'], () => {
      removeItemFromArr(this.endPageArr, petal);
    });

    rotateItem(petal, petal['tr'], petal['time']);

    setTimeout(() => {
      this.addPetal();
    }, 0 + this.petalTime);

    this.petalTime +=  5;
  }


  getPetal() {

    const petal = new MySprite(this.ctx);

    const id = Math.ceil( Math.random() * 3 );
    petal.init(this.images.get('petal_' + id));

    const randomS = (Math.random() * 0.4 + 0.6) * this.mapScale;
    petal.setScaleXY(randomS);

    const randomR = Math.random() * 360;
    petal.rotation = randomR;

    const randomX = Math.random() * this.canvasWidth;
    petal.x = randomX;
    petal.y = -petal.height / 2 * petal.scaleY;

    const randomT = 2 + Math.random() * 5;
    petal['time'] = randomT;

    let randomTR = 360 * Math.random(); // - 180;
    if (Math.random() < 0.5) { randomTR *= -1; }
    petal['tr'] = randomTR;

    return petal;
  }



  gameEnd() {
    // this.showEndPage();

    this.canTouch = true;
    this.petalTime = 0;

    this.playAudio('finish');

    this.showEndPatal();

    setTimeout(() => {
      this.showPetalFlag = false;
    }, 5000);
  }




  mapDown(event) {


    if (!this.canTouch) {
      return;
    }


    console.log(' in mapDown ');

    const arr = this.itemArrA.concat(this.itemArrB);
    for (let i = 0; i < arr.length; i++) {
      if (this.checkClickTarget(arr[i])) {
        this.clickItem(arr[i]);
        return;
      }
    }







  }


  clickTextBg(index) {
    if (this.rightFlag) {
      return;
    }

    const data = this.picArr[this.picIndex];
    if (index == Number(data.answerId)) {
      this.textBgArr[index].rightBg.visible = true;
      this.rightFlag = true;
      this.playAudio('right');
    } else {
      this.textBgArr[index].wrongBg.visible = true;
      this.playAudio('wrong');
    }
  }

  clickPicBg(index) {
    if (this.rightFlag) {
      return;
    }

    const data = this.picArr[this.picIndex];
    if (index == Number(data.answerId)) {
      this.picBgArr[index].rightBg.visible = true;
      this.rightFlag = true;
      this.playAudio('right');
    } else {
      this.picBgArr[index].wrongBg.visible = true;
      this.playAudio('wrong');
    }
  }


  closeBtnClick() {
    this.mask.visible = false;
    // this.grouoLightIndex = 0;
    this.animaNewStopRun = false;
    // this.lightDelayTime = 1;
    for (let i = 0; i < this.ballArr.length; i++) {
      this.ballArr[i].light.alpha = 0;
    }
    this.initLightAnimaNew();
    this.playAudio('click_1');
  }

  goBtnClick() {

    this.canTouch = false;

    this.wheelRun();

    this.playAudio('click_1');
    this.playAudio('bg');
  }


  getNextItemIndex() {


    if (!this.idArr || this.idArr.length <= 0) {
      this.idArr = [];
      for (let i = 0; i < this.picArr.length; i++) {
        this.idArr.push(i);
      }
      this.idArr = randomSortByArr(this.idArr);
    }

    return this.idArr.pop();
  }


  wheelRun() {

    const rateArea = 0.9;
    const num = this.picArr.length;
    const id = this.getNextItemIndex();
    const angle = 360 / num ; // this.picArr.length;
    const targetAngle = 360 * 4 + id * angle - 90 - (angle * (1 - rateArea) / 2 + angle * rateArea * Math.random());
    console.log('id: ', id);

    this.picIndex = id;
    this.lightDelayTime = 0;

    rotateItem(this.wheel, 360 * 11, 2.2 , () => {

      this.wheel.rotation = this.wheel.rotation % 360;
      rotateItem(this.wheel, targetAngle, 1.6, () => {
        this.wheel.rotation = this.wheel.rotation % 360;

        this.showAllLight();

        this.playAudio('tip');
        moveItem(this.arrow, this.arrow.x, this.arrow.y - 20 * this.mapScale, 0.5, ( ) => {

          setTimeout(() => {
            this.showQuestionWindow();
          }, 0.7 * 1000);

        }, TWEEN.Easing.Elastic.Out);

      }, TWEEN.Easing.Sinusoidal.Out);

    });

    moveItem(this.arrow, this.arrow.x, this.arrow.baseY, 0.3, ( ) => {

    }, TWEEN.Easing.Cubic.Out);



    this.animaStopRun = false;
    this.animaNewStopRun = true;
    for (let i = 0; i < this.ballArr.length; i++) {
      this.ballArr[i].light.alpha = 0;
    }
    this.lightDelayTime = 0;
    this.initLightAnima();

    this.playAudio('wheel_run');
  }

  showAllLight() {

    this.animaStopRun = true;
    // clearTimeout(this.lightDelayId);

    setTimeout(() => {
      for (let i = 0; i < this.ballArr.length; i++) {
        showItem(this.ballArr[i].light, 0.02);
        // this.ballArr[i].light.alpha = 1;
      }
    }, 0.03 * 1000);


  }

  showQuestionWindow() {


    this.setQuestionWindowData();
    this.mask.visible = true;




    this.questionBg.setScaleXY(this.mapScale * 0.9);

    scaleItem(this.questionBg, this.mapScale, 0.5, () => {
      this.canTouch = true;
    }, TWEEN.Easing.Elastic.Out);

    this.playAudio('show_window');
  }

  setQuestionWindowData() {

    this.rightFlag = false;

    const data = this.picArr[this.picIndex];

    if (data.question_pic_url) {
      this.questionLabel.text = data.question;
      this.questionLabel.visible = true;
      this.questionLabel2.visible = false;

    } else {
      this.questionLabel2.text = data.question;
      this.questionLabel2.visible = true;
      this.questionLabel.visible = false;
    }

    const answerArr = data.answerArr;

    if (data.answerType == 'A') {
      this.showArr(this.textBgArr);
      this.hideArr(this.picBgArr);
      this.hideArr(this.answerTitleArr);
    } else {
      this.showArr(this.picBgArr);
      this.showArr(this.answerTitleArr);
      this.hideArr(this.textBgArr);
    }

    for (let i = 0; i < answerArr.length; i++) {
      this.textBgArr[i].rightBg.visible = false;
      this.textBgArr[i].wrongBg.visible = false;
      if (this.answerLabelArr[i] && answerArr[i].text) {
        this.answerLabelArr[i].text = answerArr[i].text;
      } else {
        this.answerLabelArr[i].text = '';
      }
    }


    if (data.question_pic_url) {

      const picRect = this.questionPicRect;
      picRect.removeChildren();

      const pic = new MySprite(this.ctx);
      pic.init(this.images.get(data.question_pic_url));
      pic.setScaleXY(getMinScale(pic, picRect.width));
      pic.x = picRect.width / 2;
      pic.y = picRect.height / 2;
      picRect.addChild(pic);

      this.questionPicRect.visible = true;

    } else {

      this.questionPicRect.visible = false;
    }


    const picLen = 206;
    for (let i = 0; i < 4; i++) {
      const picBg = this.picBgArr[i];
      picBg.removeChildren();
      picBg.wrongBg.visible = false;
      picBg.rightBg.visible = false;

      const picUrl = answerArr[i].pic_url;
      if (picUrl) {
        const pic = new MySprite(this.ctx);
        pic.init(this.images.get(picUrl));
        pic.y = 35;
        pic.setScaleXY(getMinScale(pic, picLen));
        picBg.addChild(pic);
      }
    }


  }



  clickItem(item) {

    const itemAudio = this.audioObj[item.data.audio_url];
    if (itemAudio) {
      itemAudio.pause();
      itemAudio.curTime = 0;
    }


    if (item.linkFlag) {
      if (itemAudio) {
        itemAudio.play();
      }
      return;
    }

    // if (this.curItem == item) {
    //   return;
    // }


    if (this.curItem) {

      if (this.curItem.type == item.type) {
        // 切换
        this.hideItemDot(this.curItem);
        this.showItemDot(item);

      } else if (this.curItem.data.id != item.data.id) {
        // 错误
        this.hideItemDot(this.curItem);
        shake(item, 0.5, null, 0.5);
        this.playAudio('wrong');
        this.curItem = null;
        return;

      } else {
        // 正确

        this.showItemDot(item);

        const oldItem = this.curItem;
        const newItem = item;
        setTimeout(() => {
          this.showLinkAnima(oldItem, newItem);
        }, 0.3 * 1000);

        this.canTouch = false;

      }

    } else {

      // 首次点
      this.showItemDot(item);

    }


    item.setScaleXY(this.mapScale);
    jelly(item, 0.6);



    if (itemAudio) {

      this.playAudio('click', true, () => {
        itemAudio.play();
      });

    } else {
      this.playAudio('click', true);
    }

    // if (!itemAudio) {
    //   this.playAudio('click', true);
    // }



    const curData = item;
    console.log("curData: ", curData);
    const audio = this.audioObj[curData.audio_url];
    if (audio) {
      audio.play();
    }

    this.curItem = item;
  }

  showItemDot(item) {

    // if (item.dot.visible) {
    //   return;
    // }
    if (item.sTween) {
      item.sTween.stop();
    }

    const dot = item.dot;
    dot.visible = true;
    dot.setScaleXY(0);
    item.sTween = scaleItem(dot, this.mapScale, 0.3, () => {
      item.sTween = null;
    }, TWEEN.Easing.Cubic.Out);
  }

  hideItemDot(item) {

    // if (!item.dot.visible) {
    //   return;
    // }
    if (item.sTween) {
      item.sTween.stop();
    }

    const dot = item.dot;
    dot.visible = true;
    item.sTween = scaleItem(dot, 0, 0.3, () => {
      item.sTween = null;
    }, TWEEN.Easing.Cubic.Out);
  }

  showLinkAnima(oldItem, newItem) {

    console.log('in showLinkAnima');

    const id = this.getLinkLineId();
    const key = 'line_' + id;

    const colorArr = [
      '#deffac',
      '#ffb062',
      '#ff66bf',
      '#fbff81',
      '#90ff62',
      '#9cffec',
      '#6dc5ff',
      '#ff6862',
      '#b8e887',
      '#ff8f8f',
    ];
    const color = colorArr[id];

    const oldPos = {x: oldItem.x, y: oldItem.y + oldItem.dot.y * oldItem.scaleY};
    const newPos = {x: newItem.x, y: newItem.y + newItem.dot.y * newItem.scaleY};

    const line = new MySprite();
    line.init(this.images.get(key));
    line.setScaleXY(this.mapScale);
    line.anchorX = (line.width - line.height / 2) / line.width;
    line.anchorY = 0;
    line.x = oldPos.x;
    line.y = oldPos.y;
    this.bgArr.push(line);

    if (newPos.x < oldPos.x) {
      line.scaleX *= -1;
    }




    const angle = getAngleByPos(oldPos.x, oldPos.y, newPos.x, newPos.y);
    line.rotation = angle + 180;

    const distance = getPosDistance(oldPos.x, oldPos.y, newPos.x, newPos.y);
    const targetS = distance / line.height;

    // const dot = new ShapeCircle();
    // dot.setRadius(11 / 2);
    // dot.setScaleXY(this.mapScale);
    // dot.fillColor = color;
    // this.bgArr.push(dot);

    tweenChange(line, {scaleY: targetS}, 1, () => {
      this.linkEnd(oldItem, newItem);
    }, TWEEN.Easing.Sinusoidal.Out , (i, pro) => {

      // const len = line.height * line.scaleY;
      // const p = getPosByAngle(angle, len);
      // dot.x = line.x;
      // dot.y = line.y;
      // dot.x += p.x;
      // dot.y -= p.y;
    });

    this.playAudio('line');
  }

  linkEnd(oldItem, newItem) {

    this.canTouch = true;
    this.curItem = null;

    oldItem.linkFlag = true;
    newItem.linkFlag = true;


    showPopParticle(this.images.get('star'), oldItem.dot, oldItem);
    scaleItem(oldItem.dot, 0, 0.5);
    showPopParticle(this.images.get('star'), newItem.dot, newItem);
    scaleItem(newItem.dot, 0, 0.5);

    this.playAudio('star');

    this.checkGameEnd();
  }


  checkGameEnd() {

    for (let i = 0; i < this.itemArrA.length; i++) {

      if (!this.itemArrA[i].linkFlag) {
        return;
      }
    }


    this.gameEnd();
  }



  getLinkLineId() {
    if (!this.linkIdArr || this.linkIdArr.length <= 0) {
      this.linkIdArr = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9];
    }

    this.linkIdArr = randomSortByArr(this.linkIdArr);

    return this.linkIdArr.pop();
  }





  changeCard() {

    this.canTouch = false;
    const x = this.canvasWidth * 1.5;
    const y = this.canvasHeight * - 0.7;
    moveItem(this.curCard, x, y, 1, () => {
      // this.canTouch = true;
    }, TWEEN.Easing.Sinusoidal.Out);

    rotateItem(this.curCard, 150);


    this.bottomCard.visible = true;
    scaleItem(this.bottomCard, this.mapScale, 0.6, () => {
      this.canTouch = true;
    }, TWEEN.Easing.Elastic.Out);
    this.curCard = this.bottomCard;

    this.addBottomCard();

  }

  addBottomCard() {

    const bottomCard = new MySprite(this.ctx);
    bottomCard.init(this.images.get(this.getFrameColor()));
    bottomCard.setScaleXY(this.mapScale * 0.95);
    bottomCard.x = this.canvasWidth / 2;
    bottomCard.y = this.canvasHeight / 2;
    bottomCard.visible = false;
    this.addPic(bottomCard);

    this.renderArr.unshift(bottomCard);
    this.bottomCard = bottomCard;
  }



  moveArm1() {

    this.canTouch = false;
    const arm1 = this.arm1;
    const offX = this.canvasWidth / 2 - this.pageW / 2 * this.mapScale;
    const tx = offX - (arm1.width) * arm1.scaleX + this.pageOffX * arm1.scaleX;

    moveItem(this.arm1, tx, arm1.y, 0.8, () => {
     this.canTouch = true;
     this.clickLeft();
    } );
  }

  moveArm2() {

    const arm1 = this.arm1;
    const arm2 = this.arm2;
    const offX = this.canvasWidth / 2 - this.pageW / 2 * this.mapScale;
    const tx = offX - (arm1.width) * arm1.scaleX + this.pageOffX * arm1.scaleX;

    this.canTouch = false;

    moveItem(arm2, this.canvasWidth - tx, arm2.y, 0.8, () => {
     this.canTouch = true;
     this.clickRight();
    } );

  }



  clickTitle() {
    this.titleAudio.play();
  }

  clickEmpty() {
    this.moveDown();
  }


  clickBall() {

    // console.log('in clickBall');

    this.canTouch = false;

    const down = () => {

      const targetY = this.stick.y + this.stick.height;
      tweenChange(this.ball, {y: targetY}, 0.8, () => {
        up();
      }, TWEEN.Easing.Quadratic.In, () => {
        this.stick.scaleY = (this.stick.y - this.ball.y) / this.stick.height;
      });

      if (this.curPic) {
        hideItem(this.curPic, 0.7);
        showItem(this.mask, 0.7);
      }
    };

    const up = () => {
      const targetY = this.stick.y - this.stick.height;
      tweenChange(this.ball, {y: targetY}, 0.8, () => {
        this.canTouch = true;
      }, TWEEN.Easing.Quadratic.Out, () => {
        this.stick.scaleY = (this.stick.y - this.ball.y) / this.stick.height;
      });

      this.showPic();
    };

    down();
  }

  showPic() {




    this.mask.removeChildren();

    const data = this.picArr[this.picIndex];
    this.curData = data;

    const curPic = new MySprite(this.ctx);
    curPic.init(this.images.get(data.pic_url));
    const sx = this.picW / curPic.width;
    const sy = this.picH / curPic.height;
    const s = Math.min(sx, sy);
    curPic.setScaleXY(s);

    this.robot.addChild(curPic);
    curPic.x = this.mask.x;
    curPic.y = this.mask.y;

    this.curPic = curPic;

    curPic.alpha = 0;
    showItem(curPic);
    hideItem(this.mask);

    this.picIndex ++;
    if (this.picIndex >= this.picArr.length) {
      this.picIndex = 0;
    }



  }


  clickPic() {

    // console.log('in clickPic');
    const curData = this.curData;
    const audio = this.audioObj[curData.audio_url];
    if (audio) {
      audio.play();
    }
  }


  clickLeft() {
    const curData = this.picArr[this.picIndex];
    const audio = this.audioObj[curData.word_1_audio_url];
    if (audio) {
      audio.play();
    }
  }

  clickRight() {
    const curData = this.picArr[this.picIndex];
    const audio = this.audioObj[curData.word_2_audio_url];
    if (audio) {
      audio.play();
    }
  }

  clickCenter() {

    console.log(' in clickCenter');

    this.canTouch = false;


    this.arm1.visible = false;
    this.arm2.visible = false;

    this.showArr(this.centerPageArr);

    setTimeout(() => {
      this.arm1.visible = true;
      this.arm2.visible = true;

      this.hideArr(this.centerPageArr);

      this.arm1.page1.visible = false;
      this.arm1.page2.visible = true;

      this.arm2.page1.visible = false;
      this.arm2.page2.visible = true;

      this.canTouch = true;
    }, 0.25 * 1000);
    // this.arm1.centerSpr.visible = true;

    // this.arm1.centerSpr.x = this.arm1.x;
    // this.arm1.centerSpr.y = this.arm1.y;



  }







  mapMove(event) {


  }

  mapUp(event) {


  }







  moveDown() {

    this.canTouch = false;

    const data = {y: this.arm1.y};
    const tween = tweenChange(data, {y: this.arm1.y + this.canvasHeight}, 1,
      () => {
      this.canTouch = true;
      this.resetArm();
    },
      TWEEN.Easing.Quadratic.In,
      (item, progress) => {

      this.arm1.y = item.y;
      this.arm2.y = item.y;

    });


  }



  update() {


    this.animationId = window.requestAnimationFrame(this.update.bind(this));
    // 清除画布内容
    this.ctx.clearRect(0, 0, this.canvasWidth, this.canvasHeight);


    TWEEN.update();



    // this.updateWordArr();
    //
    this.updateArr(this.bgArr);
    this.updateArr(this.renderArr);
    this.updateArr(this.endPageArr);




  }


  updateItem(item) {
    if (item) {
      item.update();
    }
  }

  updateArr(arr) {
    if (!arr) {
      return;
    }
    for (let i = 0; i < arr.length; i++) {
      arr[i].update(this);
    }
  }





  initListener() {

    this.winResizeEventStream
      .pipe(debounceTime(500))
      .subscribe(data => {
        this.renderAfterResize();
      });




      if (this.IsPC()) {

        this.canvas.nativeElement.addEventListener('mousedown', (event) => {

          setMxMyByMouse(event);
          this.mapDown(event);
        });

        this.canvas.nativeElement.addEventListener('mousemove', (event) => {

          setMxMyByMouse(event);
          this.mapMove(event);
        });

        this.canvas.nativeElement.addEventListener('mouseup', (event) => {

          setMxMyByMouse(event);
          this.mapUp(event);
        });


        const setMxMyByMouse = (event) => {

          this.mx = event.offsetX;
          this.my = event.offsetY;
        };



      } else {

        this.canvas.nativeElement.addEventListener('touchstart', (event) => {

          setMxMyByTouch(event);
          this.mapDown(event);
        });

        this.canvas.nativeElement.addEventListener('touchmove', (event) => {
          setMxMyByTouch(event);
          this.mapMove(event);
        });

        this.canvas.nativeElement.addEventListener('touchend', (event) => {
          setMxMyByTouch(event);
          this.mapUp(event);
        });

        this.canvas.nativeElement.addEventListener('touchcancel', (event) => {
          setMxMyByTouch(event);
          this.mapUp(event);
        });


        const setMxMyByTouch = (event) => {

          // console.log('in setMxMyByTouch', event);
          if (event.touches.length <= 0) {
            return;
          }

          if (this.canvasLeft == null) {
            setParentOffset();
          }

          this.mx = event.touches[0].pageX - this.canvasLeft;
          this.my = event.touches[0].pageY - this.canvasTop;
        };


        const setParentOffset = () => {

          const rect = this.canvas.nativeElement.getBoundingClientRect();
          this.canvasLeft = rect.left;
          this.canvasTop = rect.top;
        };
      }



  }


  playAudio(key, now = false, callback = null) {

    const audio = this.audioObj[key];
    if (audio) {
      if (now) {
        audio.pause();
        audio.currentTime = 0;
      }

      if (callback) {
        audio.onended = () => {
          callback();

          audio.onended = null;
        };
      }
      audio.play();
    }
  }




  showArr(arr) {
    if (!arr) {
      return;
    }
    for (let i = 0; i < arr.length; i++) {
      arr[i].visible = true;
    }
  }

  hideArr(arr) {
    if (!arr) {
      return;
    }
    for (let i = 0; i < arr.length; i++) {
      arr[i].visible = false;
    }
  }



  IsPC() {

    if (window['ELECTRON']) {
      return false; // 封装客户端标记
    }


    if (document.body.ontouchmove !== undefined && document.body.ontouchmove !== undefined) {
      return false;
    } else {
      return true;
    }

  }


  loadResources() {
    const pr = [];
    this.rawImages.forEach((value, key) => {// 预加载图片

      const p = this.preload(value)
        .then(img => {
          this.images.set(key, img);
        })
        .catch(err => console.log(err));

      pr.push(p);
    });

    this.rawAudios.forEach((value, key) => {// 预加载图片

      const a = this.preloadAudio(value)
        .then(() => {
          // this.images.set(key, img);
        })
        .catch(err => console.log(err));

      pr.push(a);
    });
    return Promise.all(pr);
  }

  preload(url) {
    return new Promise((resolve, reject) => {
      const img = new Image();
      // img.crossOrigin = "anonymous";
      img.onload = () => resolve(img);
      img.onerror = reject;
      img.src = url;
    });
  }

  preloadAudio(url) {
    return new Promise((resolve, reject) => {
      const audio = new Audio();
      audio.oncanplay = (a) => {
        resolve();
      };
      audio.onerror = () => {
        reject();
      };
      audio.src = url;
      audio.load();
    });
  }


  renderAfterResize() {
    this.canvasWidth = this.wrap.nativeElement.clientWidth;
    this.canvasHeight = this.wrap.nativeElement.clientHeight;
    this.init();
  }



  checkClickTarget(target) {

    const rect = target.getBoundingBox();

    if (this.checkPointInRect(this.mx, this.my, rect)) {
      return true;
    }
    return false;
  }

  getWorlRect(target) {

    let rect = target.getBoundingBox();

    if (target.parent) {

      const pRect = this.getWorlRect(target.parent);
      rect.x += pRect.x;
      rect.y += pRect.y;
    }
    return rect;
  }

  checkPointInRect(x, y, rect) {
    if (x >= rect.x && x <= rect.x + rect.width) {
      if (y >= rect.y && y <= rect.y + rect.height) {
        return true;
      }
    }
    return false;
  }

  getPosByAngle(angle, len) {

    const radian = angle * Math.PI / 180;
    const x = Math.sin(radian) * len;
    const y = Math.cos(radian) * len;

    return {x, y};

  }

  getPosDistance(sx, sy, ex, ey) {

    const _x = ex - sx;
    const _y = ey - sy;
    const len = Math.sqrt( Math.pow(_x, 2) + Math.pow(_y, 2) );
    return len;
  }

}
