import {Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef, ChangeDetectorRef} from '@angular/core';
import {NzMessageService, NzModalService} from 'ng-zorro-antd';
import * as _ from 'lodash';


@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.scss']
})
export class FormComponent implements OnInit, OnChanges, OnDestroy {
  // 储存数据用
  saveKey = 'picture-group';
  // 储存对象
  item;

  groups: Array<{
    name: string,
    options: Array<{
      text: string,
      pic_id: number,
      showText: boolean,
      showPic: boolean
    }>
  }>;


  constructor(private appRef: ApplicationRef,
              private changeDetectorRef: ChangeDetectorRef,
              private modalService: NzModalService, 
              private nzMessageService: NzMessageService,) {

  }


  ngOnInit() {

    this.item = {
      contentObj: {
        
      }
    };

    // 获取存储的数据
    (window as any).courseware.getData((data) => {
      if (data) {
        this.item = data;
      }

      this.init();
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();

    }, this.saveKey);

  }


  ngOnChanges() {
    this.init();
  }

  ngOnDestroy() {

  }



  init() {
    if (!this.item.contentObj.groups) {
      this.groups = [
        {name: '', options: []},
        {name: '', options: []}
      ];
    } else {
      this.groups = this.item.contentObj.groups;
    }
  }
  onHandleSwitchContent(groupIndex, item) {
    item.showText = !item.showText;
    item.showPic = !item.showPic;
    this.item.contentObj.groups = this.groups;
    this.save();
  }
  onDeleteCoursewareItem(groupIndex, index) {
    this.modalService.confirm({
      nzTitle: 'Are you sure delete this?',
      nzOkText: 'Yes',
      nzOkType: 'danger',
      nzCancelText: 'No',
      nzOnOk: () => {
        this.groups[groupIndex].options.splice(index, 1);
        this.item.contentObj.groups = this.groups;
        this.save();
      },
    });
  }
  onHandleOptionItemImage(groupIndex, e, index) {
    this.groups[groupIndex].options[index].pic_id = e.url;
    this.item.contentObj.groups = this.groups;
    this.save();
  }
  addNewOptionItem (groupIndex) {
    const content = {
      text: '',
      pic_id: 0,
      showText: true,
      showPic: false
    };
    if (!this.groups) {
      this.groups = [];
    }
    let group = _.get(this.groups, groupIndex, null);
    if (!group || group.constructor.name !== 'Object') {
      group = {
        name: '',
        options: []
      };
      this.groups[groupIndex] = group;
    }
    let options = _.get(this.groups[groupIndex] , 'options', null);
    if (!options || options.constructor.name !== 'Array') {
      options = [];
      this.groups[groupIndex].options = options;
    }
    if (this.groups[groupIndex].options.length === 5) {
      this.nzMessageService.info('you can only add five items!')
      return;
    }
    this.groups[groupIndex].options.push(content);
    this.updateOptionItemText();
  }
  updateGroupText(evt?: {target: {value: ''}}, group?: {name: ''}) {
    let u = true;
    if (evt ) {
      if (evt.target.value === group.name) {
        u = false;
      } else {
        group.name = evt.target.value;
      }
    }
    this.item.contentObj.groups = this.groups;
    if (u) {
      this.save();
    }
  }
  updateOptionItemText(evt?: {target: {value: ''}}, item?: {text: ''}) {
    let u = true;
    if (evt ) {
      if (evt.target.value === item.text) {
        u = false;
      } else {
        item.text = evt.target.value;
      }
    }
    this.item.contentObj.groups = this.groups;
    if (u) {
      this.save();
    }
  }

  
  /**
   * 储存数据
   */
  save() {
    (<any> window).courseware.setData(this.item, null, this.saveKey);
    this.refresh();
  }

  /**
   * 刷新 渲染页面
   */
  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }

}

