import {Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef, ChangeDetectorRef} from '@angular/core';
import * as _ from 'lodash';
import { NzModalService } from 'ng-zorro-antd';


@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.scss']
})
export class FormComponent implements OnInit, OnChanges, OnDestroy {

  // 储存数据用
  saveKey = 'ww_question';
  // 储存对象
  item;
  originContent;
  options = [];
  OPTION_TYPE = {TEXT: 1, PIC: 2, AUDIO: 3};


  constructor(private appRef: ApplicationRef,
              private modalService: NzModalService,
              private changeDetectorRef: ChangeDetectorRef) {

  }


  ngOnInit() {

    this.item = {
      contentObj: {}
    };

    // 获取存储的数据
    (window as any).courseware.getData((data) => {

      if (data) {
        this.item = data;
        this.originContent = {...this.item.contentObj};
        this.options = _.get(this.item.contentObj, 'options', []);
        // Ken 2019-04-14 17:41 把showPic, showText的逻辑换为type
        _.forEach(this.options, o => {
          if (_.isUndefined(o.type)) {
            o.type = o.showPic ? this.OPTION_TYPE.PIC : this.OPTION_TYPE.TEXT;
          }
        });
      }


      this.init();
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();

    }, this.saveKey);

  }


  ngOnChanges() {
  }

  ngOnDestroy() {
  }



  init() {

  }


  // onImageUploadSuccess(e, key) {
  //
  //     this.item[key] = e.url;
  //     this.save();
  // }


  // onAudioUploadSuccess(e, key) {
  //
  //   this.item[key] = e.url;
  //   this.save();
  // }



  /**
   * 储存数据
   */
  save() {
    (window as any).courseware.setData(this.item, null, this.saveKey);
    this.refresh();
  }

  /**
   * 刷新 渲染页面
   */
  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }


  onHandleQuestionImage(e) {
    this.item.contentObj.pic_id = e.url;
    this.save();
  }

  updateQuestionTitle() {
    this.save();
  }

  onHandleOptionItemImage(e, index) {
    this.options[index].pic_id = e.url;
    this.item.contentObj.options = this.options;
    this.save();
  }

  onHandleOptionItemAudio(e, index) {
    this.options[index].audio_id = e.url;
    this.item.contentObj.options = this.options;
    this.save();
  }

  updateOptionItemText(index) {
    this.item.contentObj.options = this.options;
    this.save();
  }

  setRightAnswer(index) {
    this.options[index].right = !this.options[index].right;
    this.item.contentObj.options = this.options;
    this.save();
  }

  addNewOptionItem() {
    const content = {
      text: '',
      pic_id: null,
      right: false,
      type: this.OPTION_TYPE.TEXT,
    };
    this.options.push(content);
  }

  onHandleSwitchContent(item) {
    switch (item.type) {
      case this.OPTION_TYPE.TEXT:
        item.type = this.OPTION_TYPE.PIC;
        break;
      case this.OPTION_TYPE.PIC:
        item.type = this.OPTION_TYPE.AUDIO;
        break;
      case this.OPTION_TYPE.AUDIO:
        item.type = this.OPTION_TYPE.TEXT;
        break;
    }
    this.item.contentObj.options = this.options;
    this.save();
  }
  onMovePage(index, direction) {
    const temp = this.options[index + direction];
    this.options[index + direction] = this.options[index];
    this.options[index] = temp;
    this.options = [...this.options];
    this.item.contentObj.options = this.options;
    this.save();
  }

  onDeleteCoursewareItem(index) {
    this.modalService.confirm({
      nzTitle: 'Are you sure delete this?',
      nzOkText: 'Yes',
      nzOkType: 'danger',
      nzCancelText: 'No',
      nzOnOk: () => {
        this.options.splice(index, 1);
        this.item.contentObj.options = this.options;
        this.save();
      },
    });
  }

}

