import {ChangeDetectorRef, ApplicationRef, Component, ElementRef, ViewChild, OnInit, Input, OnDestroy, HostListener} from '@angular/core';
import * as _ from 'lodash';
import {
  Label,
  MySprite, tweenChange,

} from './Unit';
import {res, resAudio} from './resources';

import {Subject} from 'rxjs';
import {debounceTime} from 'rxjs/operators';

import TWEEN from '@tweenjs/tween.js';
import { animate, keyframes, state, style, transition, trigger } from '@angular/animations';




@Component({
  selector: 'app-play',
  templateUrl: './play.component.html',
  styleUrls: ['./play.component.scss'],
  animations: [
    trigger('tip-border', [
      state('right', style({border: '0.3rem solid #52E55D', 'background-color': '#52E55D', transform: 'scale(1)'})),
      state('none', style({transform: 'scale(1)'})),
      state('wrong', style({border: '0.3rem solid #ff3333', 'background-color': '#ff3333', transform: 'scale(1)'})),
      transition('none => wrong', animate('.2s ease-in', keyframes([
        style({transform: 'scale(1)'}),
        style({transform: 'scale(0.6)'}),
        style({transform: 'scale(1)'}),
      ]))), // 第一个参数:动画时间, 第二个参数:动画延迟时间
      transition('none => right', animate('.2s ease-in', keyframes([
        style({transform: 'scale(1)'}),
        style({transform: 'scale(0.6)'}),
        style({transform: 'scale(1)'}),
      ]))),
      transition('wrong => none', animate('.2s ease-out'))
    ]),
    trigger('tip-circle', [
      state('right', style({'background-color': '#52E55D'})),
      state('none', style({})),
      state('wrong', style({'background-color': '#ff3333'})),
      transition('none => wrong', animate('.2s ease-in')), // 第一个参数:动画时间, 第二个参数:动画延迟时间
      transition('none => right', animate('.2s ease-in')),
      transition('wrong => none', animate('.2s ease-out'))
    ]),
    trigger('zoom', [
      state('in', style({
        position: 'absolute', 'z-index': '1', top: '0', left: '0', right: '0', bottom: '0', margin: 'auto',
        height: '60%', 'object-fit': 'contain', 'max-width': '80%'
      })),
      state('none', style({})),
      transition('none => in', animate('.3s', keyframes([
        style({
          height: '10%', position: 'absolute', 'z-index': '1', top: '0', left: '0',
          right: '0', bottom: '0', margin: 'auto', 'object-fit': 'contain', 'max-width': '80%',
          opacity: '0'
        }),
        style({
          height: '20%', position: 'absolute', 'z-index': '1', top: '0', left: '0',
          right: '0', bottom: '0', margin: 'auto', 'object-fit': 'contain', 'max-width': '80%',
          opacity: '0.2'
        }),
        style({
          height: '30%', position: 'absolute', 'z-index': '1', top: '0', left: '0',
          right: '0', bottom: '0', margin: 'auto', 'object-fit': 'contain', 'max-width': '80%',
          opacity: '0.4'
        }),
        style({
          height: '40%', position: 'absolute', 'z-index': '1', top: '0', left: '0',
          right: '0', bottom: '0', margin: 'auto', 'object-fit': 'contain', 'max-width': '80%',
          opacity: '0.6'
        }),
        style({
          height: '50%', position: 'absolute', 'z-index': '1', top: '0', left: '0',
          right: '0', bottom: '0', margin: 'auto', 'object-fit': 'contain', 'max-width': '80%',
          opacity: '0.8'
        }),
      ]))), // 第一个参数:动画时间, 第二个参数:动画延迟时间
      transition('in => none', animate('.5s ease-out'))
    ])
  ]
})
export class PlayComponent implements OnInit, OnDestroy {
  saveKey = 'ww_question';
  options;
  zoomIn;
  rightAudio = new Audio();
  wrongAudio = new Audio();
  OPTION_TYPE = {TEXT: 1, PIC: 2, AUDIO: 3};
  optionAudio = new Audio();

  // 数据
  data;
  constructor(private appRef: ApplicationRef, private changeDetectorRef: ChangeDetectorRef) {
    this.rightAudio.src = 'assets/right.mp3';
    this.rightAudio.load();
    this.wrongAudio.src = 'assets/wrong.mp3';
    this.wrongAudio.load();
  }

  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }

  ngOnInit() {

    this.data = {
      contentObj: {
        pic_id: 'http://staging-teach.cdn.ireadabc.com/5502addf299f5f34dc181f993f81e311.png',
        title: '123123123',
        options: [{
          text: '1111',
          pic_id: null,
          right: true,
          type: 3,
          audio_id: 'http://staging-teach.cdn.ireadabc.com/ab0872d9ed584c06181d41d9c7c4bf75.mp3'
        }, {
          text: '222',
          pic_id: 'http://staging-teach.cdn.ireadabc.com/d4bf481e893b0a46cac9eef21930f822.png',
          right: false,
          type: 2
        }, {
          text: '3333',
          pic_id: null,
          right: false,
          type: 1
        }, {
          text: '4444',
          pic_id: null,
          right: false,
          type: 1
        }]
      }
    };
   // 获取数据
    const getData = (window as any).courseware.getData;
    getData((data) => {

      if (data && typeof data === 'object') {
        this.data = data;

      }
      this.zoomIn = false;
      this.options = _.get(this.data.contentObj, 'options', []).map(item => {
        item.state = '';
        // Ken 2019-04-15 22:38  把showPic, showText的逻辑换为type
        if (_.isUndefined(item.type)) {
          item.type = item.showPic ? this.OPTION_TYPE.PIC : this.OPTION_TYPE.TEXT;
        }
        return item;
      });
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();
      if (window['air']) {
        window['air'].hideAirClassLoading(this.saveKey, this.data);
      }

    }, this.saveKey);

  }

  ngOnDestroy() {
    this.rightAudio.pause();
    this.wrongAudio.pause();
    this.optionAudio.pause();
    this.rightAudio = null;
    this.wrongAudio = null;
    this.optionAudio = null;
  }

  transCharCode(index) {
    return String.fromCharCode(65 + index);
  }

  handleAnimation(item) {
    if (item.right) {
      item.state = 'right';
      this.rightAudio.play();
    } else {
      item.state = 'wrong';
      this.wrongAudio.play();
      setTimeout(() => {
        item.state = '';
      }, 1500);
    }
    this.changeDetectorRef.markForCheck();
    this.changeDetectorRef.detectChanges();
    this.refresh();
  }

  onHandleZoomIn(e) {
    e.stopPropagation();
    this.zoomIn = !this.zoomIn;
    this.changeDetectorRef.markForCheck();
    this.changeDetectorRef.detectChanges();
    this.refresh();
  }

  playAudio(option, e) {
    e.stopPropagation();
    this.optionAudio.src = option.audio_id;
    // this.optionAudio.load();
    this.optionAudio.play();
    this.changeDetectorRef.markForCheck();
    this.changeDetectorRef.detectChanges();
    this.refresh();
  }

}
