import {Directive, ElementRef, Input, OnChanges, SimpleChanges} from '@angular/core';
import * as _ from 'lodash';

@Directive({
  selector: '[appCustomStyle]'
})
export class CustomStyleDirective implements OnChanges {
  @Input()
  customStyle;
  @Input()
  customStyleDirtyCount;

  constructor(private el: ElementRef) {
  }

  ngOnChanges(changes: SimpleChanges) {
    const dom = this.el.nativeElement;
    // dom.style.fontFamily = this.customStyle.fontFamily;
    // dom.style.color = this.customStyle.color;
    _.assign(dom.style, this.customStyle);
    // Object.entries(this.customStyle).forEach( ([key, value]) => {
    //   dom.style[key] = value;
    // });
    dom.style.fontSize = (this.customStyle.fontSize * 10) + 'px';
    // dom.style.transform = `translate(${this.customStyle.position.left}px, ${this.customStyle.position.top}px)`;
    dom.style.left = this.customStyle.position.left + 'px';
    dom.style.top = this.customStyle.position.top + 'px';
  }

}
