import {Component, ElementRef, ApplicationRef,ChangeDetectorRef,ViewChild, OnInit, Input, OnDestroy, HostListener} from '@angular/core';

import {
  Label,
  MySprite, tweenChange,

} from './Unit';
import {res, resAudio} from './resources';

import {Subject} from 'rxjs';
import {debounceTime} from 'rxjs/operators';
import * as _ from 'lodash';;




@Component({
  selector: 'app-play',
  templateUrl: './play.component.html',
  styleUrls: ['./play.component.scss']
})
export class PlayComponent implements OnInit, OnDestroy {

  @ViewChild('box')
  box: ElementRef;
  ratio: number;
  saveKey = 'ww_text';
  items: any[];
  animations: any[];

  animationIndex = -1;
  // 数据
  data;

  constructor(private appRef: ApplicationRef,
    private changeDetectorRef: ChangeDetectorRef) {
  }


  ngOnInit() {

    this.data = {
      contentObj: {}
    };


    // 获取数据
    const getData = (window as any).courseware.getData;
    getData((data) => {

      if (data && typeof data === 'object') {
        this.data = data;
        this.init();
      }

      if (window["air"]){
        window["air"].hideAirClassLoading(this.saveKey, this.data);
      }

      this.refresh();

    }, this.saveKey);

  }

  ngOnDestroy() {
  }




  init() {

    this.items = _.get(this.data.contentObj, 'items');
    _.forEach(this.items, item => item.animationClass = null);

    this.animations = _.get(this.data.contentObj, 'animations');
    if (this.items && this.animations) {
      _.forEach(this.animations, (animation) => {
        const item = _.find(this.items, {id: animation.id});
        if (item) {
          _.assign(item, animation.initStyle);
        }
      });
    }
  }
  resize(rect) {
    if (!this.box) {
      return;
    }
    this.ratio = rect.clientWidth / this.box.nativeElement.clientWidth;
    this.box.nativeElement.style.transform = `scale(${this.ratio})`;
  }
  playOutAnimation(evt, item) {
    evt.stopPropagation();
    console.log('out out out ');
    // const idx = this.animations.findIndex((el) => {
    //   return item === el;
    // });
    // const animation = _.get(this.animations, `[${this.animationIndex}]`);
    const tEl = evt.target;
    if (tEl.tagName === 'SPAN' && tEl.className === 'text') {
      // const idx = _.findIndex(this.box.nativeElement.children, el => {
      //   return tEl.parentNode === el;
      // });
      if (!item.animationClass) {
        return;
      }
      // const anim = _.get(this.animations, `[${idx}]`);
      const css = item.animationClass.split(' ')[1];
      tEl.parentNode.classList.remove(css);
      let outCss = '';
      if (css === 'fadeInRight') {
        outCss = 'fadeOutLeft';
      } else if (css === 'fadeInDown') {
        outCss = 'fadeOutDown';
      } else if (css === 'zoomInUp') {
        outCss = 'zoomOutUp';
      } else if (css === 'rotateIn') {
        outCss = 'rotateOut';
      } else if (css === 'rollIn') {
        outCss = 'rollOut';
      }

      tEl.parentNode.classList.add(outCss);
    }
  }
  playNextAnimation(evt) {


    this.animationIndex++;
    // this.animationIndex = this.animationIndex % this.animations.length;
    const animation = _.get(this.animations, `[${this.animationIndex}]`);
    if (animation) {
      const item = _.find(this.items, {id: animation.id});
      if (item) {
        // dom已经存在了, 需要直接操作, 用ng的方式需要绕一下
        const dom = _.find(this.box.nativeElement.children, {id: `i-sentence-${animation.id}`});
        if (dom) {
          _.assign(dom.style, animation.beforeAnimation);
          item.animationClass = animation.value;
          // console.log(animation.beforeAnimation, animation.value);
        }
      }
    }
  }

  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }

}
