(function () {
  'use strict';
  if (!self.importScripts) {
    return
    var importScripts = (function (globalEval) {
      var xhr = new XMLHttpRequest;
      return function importScripts() {
        var
          args = Array.prototype.slice.call(arguments)
          , len = args.length
          , i = 0
          , meta
          , data
          , content
        ;
        for (; i < len; i++) {
          if (args[i].substr(0, 5).toLowerCase() === "data:") {
            data = args[i];
            content = data.indexOf(",");
            meta = data.substr(5, content).toLowerCase();
            data = decodeURIComponent(data.substr(content + 1));
            if (/;\s*base64\s*[;,]/.test(meta)) {
              data = atob(data);
            }
            if (/;\s*charset=[uU][tT][fF]-?8\s*[;,]/.test(meta)) {
              data = decodeURIComponent(escape(data));
            }
          } else {
            xhr.open("GET", args[i], false);
            xhr.send(null);
            data = xhr.responseText;
          }
          globalEval(data);
        }
      };
    }(eval));
  }


  // importScripts('assets/libs/audio-recorder/lame.min.js');
  self.importScripts('lame.min.js');
  var mp3Encoder, maxSamples = 1152, samplesMono, lame, config, dataBuffer;

  var clearBuffer = function () {
    dataBuffer = [];
  };

  var appendToBuffer = function (mp3Buf) {
    dataBuffer.push(new Int8Array(mp3Buf));
  };

  var init = function (prefConfig) {
    config = prefConfig || {};
    lame = new lamejs();
    mp3Encoder = new lame.Mp3Encoder(1, config.sampleRate || 44100, config.bitRate || 128);
    clearBuffer();
    self.postMessage({
      cmd: 'init'
    });
  };

  var floatTo16BitPCM = function (input, output) {
    for (var i = 0; i < input.length; i++) {
      var s = Math.max(-1, Math.min(1, input[i]));
      output[i] = (s < 0 ? s * 0x8000 : s * 0x7FFF);
    }
  };

  var convertBuffer = function (arrayBuffer) {
    var data = new Float32Array(arrayBuffer);
    var out = new Int16Array(arrayBuffer.length);
    floatTo16BitPCM(data, out);
    return out;
  };

  var encode = function (arrayBuffer) {
    samplesMono = convertBuffer(arrayBuffer);
    var remaining = samplesMono.length;
    for (var i = 0; remaining >= 0; i += maxSamples) {
      var left = samplesMono.subarray(i, i + maxSamples);
      var mp3buf = mp3Encoder.encodeBuffer(left);
      appendToBuffer(mp3buf);
      remaining -= maxSamples;
    }
  };

  var finish = function () {
    appendToBuffer(mp3Encoder.flush());
    self.postMessage({
      cmd: 'end',
      buf: dataBuffer
    });
    clearBuffer();
  };

  self.onmessage = function (e) {
    switch (e.data.cmd) {
      case 'init':
        init(e.data.config);
        break;
      case 'encode':
        encode(e.data.buf);
        break;
      case 'finish':
        finish();
        break;
    }
  };
})();
