import { Component, ElementRef, ApplicationRef, ChangeDetectorRef, ViewChild, OnInit, Input, OnDestroy, HostListener, OnChanges, AfterViewInit } from '@angular/core';
import * as _ from 'lodash';




@Component({
  selector: 'app-play',
  templateUrl: './play.component.html',
  styleUrls: ['./play.component.scss'],
})
export class PlayComponent implements OnInit, OnDestroy, OnChanges, AfterViewInit {

  // 数据
  data;
  saveKey = 'ww_video';


  @ViewChild('videoNode', {static: true})
  videoNodeRef: ElementRef;
  @ViewChild('videoProgress', {static: true})
  videoProgressRef: ElementRef;
  player: any;
  progress = 0;
  currentTime = 0;
  duration = 0;
  isPlaying = false;
  hasVideo = false;
  touchSeeking = false;
  initCover = false;
  isPlayStarted = false;


  constructor(private appRef: ApplicationRef,
    public changeDetectorRef: ChangeDetectorRef) {
  }

  ngOnInit() {
    window['vv']= this;
    this.data = {
      contentObj: {
        video_url: null
      }
    };
    // 获取数据
    const getData = ( window as any).courseware.getData;
    getData((data) => {
      console.log(4444, data);
      if (data && typeof data === 'object') {
        this.data = data;
      }
      this.hasVideo = !!this.data.contentObj.video_url;
      this.ngAfterDataInit();
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();
      window["air"] && window["air"].hideAirClassLoading(this.saveKey, this.data);

    }, this.saveKey);

    setInterval(() => {
      this.refresh();
    }, 1000);
  }

  ngOnDestroy() {
  }

  ngOnChanges(data) {

  }
  ngAfterViewInit() {

  }

  ngAfterDataInit() {
    if (!this.videoNodeRef) {
      return;
    }
    this.player = this.videoNodeRef.nativeElement;
    this.player.ontimeupdate = (event) => {
      this.onTimeUpdate(event);
    };
    this.player.onloadedmetadata = () => {
      this.currentTime = 0;
      this.duration = this.player.duration;
    };
    this.player.onseeking = () => {
      this.player.pause();
    };
    this.player.onseeked = () => {
      this.player.play();
      this.touchSeeking = false;
    };
    this.player.onplay = () => {
      this.isPlaying = true;
    };
    this.player.onpause = () => {
      this.isPlaying = false;
    };

    this.player.addEventListener('ended', () => {
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();
    })
    this.initCover = !!this.data.contentObj.pic_id;
    this.changeDetectorRef.markForCheck();
    this.changeDetectorRef.detectChanges();
    this.refresh();
  }

  playVideo() {
    if (!this.videoNodeRef) {
      return;
    }
    if (!this.player) {
      this.ngAfterDataInit();
    }
    if (!this.player) {
      return;
    }
    this.initCover = false;
    if (this.player.paused) {
      const playPromise = this.player.play();
      if (playPromise !== undefined) {
        playPromise.then(_ => {
          this.isPlayStarted = true;
        })
        .catch(error => {
          console.log('error', error);
        });
      }
    } else {
      this.player.pause();
    }
    this.changeDetectorRef.markForCheck();
    this.changeDetectorRef.detectChanges();
    this.refresh();
  }


  onTimeUpdate(event) {
    const player = event.target;
    this.currentTime = player.currentTime;
    this.progress = Math.floor((player.currentTime / player.duration) * 100);
    console.log(this.progress);
    this.duration = this.player.duration;
    this.changeDetectorRef.markForCheck();
    this.changeDetectorRef.detectChanges();
    this.refresh();
  }

  onBtnQuickSeek(delta: number) {
    this.player.currentTime += delta;
    this.changeDetectorRef.markForCheck();
    this.changeDetectorRef.detectChanges();
    this.refresh();
  }

  onProgressMouseDown(event) {
    this.player.pause();
    this.touchSeeking = true;
    this.changeDetectorRef.markForCheck();
    this.changeDetectorRef.detectChanges();
    this.refresh();
  }

  onProgressMouseMove(event) {
    if (this.touchSeeking) {
      const {target, offsetX} = event;
      this.progress = Math.floor(offsetX / target.clientWidth * 100);
    }
    this.changeDetectorRef.markForCheck();
    this.changeDetectorRef.detectChanges();
    this.refresh();
  }

  onProgressMouseUp(event) {
    const {target, offsetX} = event;
    this.player.currentTime = this.player.duration * offsetX / target.clientWidth;
    this.changeDetectorRef.markForCheck();
    this.changeDetectorRef.detectChanges();
    this.refresh();
  }

  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }


}
