import { Component, OnDestroy, OnChanges, OnInit, ApplicationRef, ChangeDetectorRef, ViewChild, ElementRef } from '@angular/core';
import { ComponentBase } from './ComponentBase';
import { MetaFormCreator } from './mataFormCreator';
import { NzMessageService } from 'ng-zorro-antd';

let replaceAll = function (str, s1, s2) {
  return str.replace(new RegExp(s1, "gm"), s2);
}
@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent extends ComponentBase implements OnInit, OnChanges, OnDestroy {
  // 储存数据用
  saveKey = "wood_input";

  // 1.猫动画可替换。
  // 2.文本内容可替换。//字体随内容缩小。
  // 3.语音替换。
  // 4.背景可替换
  // 5.3~10选项内容。
  // 6.配置对应的坐标。


  customTypeGroupArr = [

    // {
    //   name: '发音动画',
    //   rect: true,
    //   animaSmall: true,
    //   audio: true,
    // },
    // {
    //   name: '发音图片',
    //   pic: true,
    //   audio: true,
    // },
    // {
    //   name: '发音区块',
    //   rect: true,
    //   audio: true,
    // },
    // {
    //   name: '变化文本',
    //   action: {
    //     type: 'text',
    //     option: [
    //       ['fontColor', '#000000'],
    //       ['fontSize', '100'],
    //       ['opacity', '0', '100']
    //     ]
    //   },
    // },
    // {
    //   name: '变化图片',
    //   action: {
    //     type: 'pic',
    //     option: [
    //       // ['scale', '1'],
    //       ['opacity', '0', '100']
    //     ]
    //   },
    // },
    // {
    //   name: '变化动画',
    //   action: {
    //     type: 'anima',
    //     option: [
    //       // ['scale', '1'],
    //       ['opacity', '0', '100']
    //     ]
    //   },
    // },
    {
      name: '选项图片',
      drag: true,
      pic: true,
      // audio: true,
    },
    // {
    //   name: '选项文本',
    //   drag: true,
    //   audio: true,
    //   action: {
    //     type: 'text',
    //     option: [
    //       ['fontColor', '#000000'],
    //       ['fontSize', '100'],
    //     ]
    //   },
    // },
    // {
    //   name: '拖拽结束区',
    //   rect: true,
    // }
  ]

  item = {
    imgAni: {
      ske: {},
      tex: {},
      png: {}
    },
    tipSwitch: 1,//提示功能开关
    tipType: "page",
    tipBg: '',
    tipPage: [{ title: '', audio: '' }],
    title: "",
    audio: "",
    audioName: "",


    image: '',
    jumpIdx: '',

    endImgAni: {
      ske: {},
      tex: {},
      png: {}
    },
    endImgTitle: "",




    points: "",

    tips: '',
    questionScore: 0,//分数
    questions: [],
    questionText: "",

    contentMain: "",
    contentArr: [],

    video_url: "",
  };

  constructor(public nzMessageService: NzMessageService, public appRef: ApplicationRef, public changeDetectorRef: ChangeDetectorRef) {
    super(appRef, changeDetectorRef);
  }
  isVisible = false;
  deleteTitle = "是否删除题目";
  deleteCallback = function () { };
  openDelete(title, callback) {
    this.deleteCallback = callback;
    this.deleteTitle = title;
    this.isVisible = true;
  }
  handleCancel() {
    this.isVisible = false;
  }
  handleOk() {
    this.deleteCallback && this.deleteCallback();
    this.handleCancel();
  }
  init(): void {

    if (this.item.questions && this.item.questions.length == 0) {
      this.addquestion();
    }
  }

  removeoption(i, j) {
    this.openDelete("确定删除选项？", () => {
      this.item.questions[i].options.splice(j, 1);
      this.save();
    })
  }
  copyoption(i, j) {
    let data = this.item.questions[i].options[j];
    this.item.questions[i].options.push(JSON.parse(JSON.stringify(data)));
    this.save();
  }

  addoption(i) {
    this.item.questions[i].options.push({
      type: "img",
      image: "",
      audio: "",
      text: "",
      time: "",
      right: false
    });
    this.save();
  }


  removePage(idx) {
    this.item.tipPage.splice(idx, 1);
    this.save();
  }
  addPage() {
    this.item.tipPage.push({ title: "", audio: "" })
    this.save();
  }

  removequestion(idx) {
    this.openDelete("确定删除题目？", () => {
      this.item.questions.splice(idx, 1);
      this.save();
    })
  }

  addquestion() {
    this.item.questions.push({
      options: [],
      type: "img"
    });
    while (this.item.questions[0].options.length < 3) {
      this.addoption(0);
    }
    this.save();
  }
  ngChange(i, j) {
    this.save();
  }

  saveHotZone(group, e) {
    console.log('e: ', e);
    const { bgItem, hotZoneItemArr } = e;

    group.bgItem = bgItem;
    group.hotZoneItemArr = hotZoneItemArr;

    this.nzMessageService.success('保存成功');

    this.save();
  }

  onVideoUploaded(evt) {
    this.item.video_url = evt.url;
    console.log(evt);
    this.save();
  }

  changeMain() {
    //输出的数据可以识别到\n的换行符
    let arr = this.item.contentMain.split(" ");
    let oldArr = this.item.contentArr.concat();
    let contetArr = arr.map(ar => {
      let obj = {
        text: replaceAll(`${ar}`, "\n", "<br/>"),
        block: false,
        check: 1,
      }
      for (let i = 0; i < oldArr.length; i++) {
        if (obj.text == oldArr[i].text) {
          obj.block = oldArr[i].block;
          obj.check = oldArr[i].check;
          oldArr.splice(i, 1);
          break;
        }
      }
      return obj;
    })
    this.item.contentArr = contetArr;
    console.log(contetArr)
    this.save();
  }
  onBlock(item, vis) {
    item.block = vis;
    this.save();
  }


  customRadioChange(e, item, key) {
    item[key] = e;
    this.save();
  }

  onDragonBoneSave(e, item) {
    console.log(e);
    this.save();
  }

}