
const {ccclass, property} = cc._decorator;
import {asyncPlayDragonBoneAnimation} from "./utils"
@ccclass
export default class NewClass extends cc.Component {

    @property(cc.AudioSource)
    dragonBoneAudioSource:cc.AudioSource = null;
    @property(cc.AudioSource)
    picAAudioSource:cc.AudioSource = null;
    @property(cc.AudioSource)
    picCAudioSource:cc.AudioSource = null;


    // onLoad () {}

    start () {
        this.scheduleOnce(()=>{
            this.flyIn();
        },0.5);

        this.dragonBoneAudioSource.node.on(cc.Node.EventType.TOUCH_START,()=>{
            this.dragonBoneAudioSource.play();
        })
        this.picAAudioSource.node.on(cc.Node.EventType.TOUCH_START,()=>{
            this.picAAudioSource.play();
        })
        this.picCAudioSource.node.on(cc.Node.EventType.TOUCH_START,()=>{
            this.picCAudioSource.play();
        })

    }

    // update (dt) {}


    setAudioClip(ac:cc.AudioClip,type:number){
        if(type == 0){
            this.dragonBoneAudioSource.clip = ac;
        }else if(type == 1){
            this.picAAudioSource.clip = ac;
        }else if(type == 2){
            this.picCAudioSource.clip = ac;
        }
    }

    /**
     * 飞入
     */
    flyIn(){
        this.node.y = cc.winSize.height/2 + 50;
        let tween = cc.tween().to(1,{y:0},{easing:"quadOut"});
        cc.tween(this.node).then(tween).start();
    }



}
