
const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(cc.Node)
    doc: cc.Node = null;

    @property(cc.Node)
    text: cc.Node = null;

    // LIFE-CYCLE CALLBACKS:

    onLoad () {
        this.doc.on(cc.Node.EventType.TOUCH_START,()=>{
            this.doc.active = false;
            this.text.active = true;
            let tween = cc.tween().to(1,{y:0},{easing:"cubicInOut"})
            cc.tween(this.text).then(tween).start();
        })
        this.text.on(cc.Node.EventType.TOUCH_START,()=>{
            let as = this.text.getComponent<cc.AudioSource>(cc.AudioSource);
            as.play();
        })
    }

    setAudioClip(ac:cc.AudioClip){
        this.text.getComponent<cc.AudioSource>(cc.AudioSource).clip = ac;
    }
    // start () {}

    // update (dt) {}
}
