/* 
window.courseware.getData(callback,key);  //用于获取数据
window.courseware.setData(data,callback,key);  //用于存储数据
var uploadUrl = window.courseware.uploadUrl();  //上传文件的路径
var uploadData = window.courseware.uploadData();  //上传文件必须要的参数 
*/

//对应模板的名称，这个可以不写，但是最好是能写上，同时开发多个模板的情况下如果不写这个，本地缓存可能会存在混乱
var key = "yile_pdftoimage";

new Vue({
  el: '#edit-data',
  created() {
    window.courseware.getData(async (dt) => {
      this.fileData = dt;
    },key);
    window['air'].getUploadCallback = (url, data) => {
      this.uploadUrl = url;
      this.uploadCover = data;
      this.uploadData = data;
    };
  },
  data() {
    var protocolStr = document.location.protocol;
    return {
      //封面上传相关
      fileData: null,
      uploadPdfUrl: `${protocolStr}//opensource.iteachabc.com/pdfUpload`,
      uploadUrl: window.courseware.uploadUrl(),
      uploadCover: window.courseware.uploadData(),
      uploadData: window.courseware.uploadData(),
      uploading: false,
      uploadProgress: 0,
      xhr: null,

      showErrorMsg: false,
    }
  },
  methods: {
    customUpload(options) {
      this.uploading = true;
      this.uploadProgress = 0;
      
      const formData = new FormData();
      formData.append('file', options.file);
      
      // 创建 XMLHttpRequest
      const xhr = new XMLHttpRequest();
      
      // 保存 xhr 实例用于取消上传
      this.xhr = xhr;
      
      xhr.upload.onprogress = (event) => {
        if (event.lengthComputable) {
          this.uploadProgress = Math.round((event.loaded * 100) / event.total);
        }
      };
      
      xhr.onload = () => {
        if (xhr.status === 200) {
          try {
            const response = JSON.parse(xhr.responseText);
            this.handleCoverSuccess(response, options.file);
          } catch (e) {
            this.handleCoverError(new Error('解析响应失败'));
          }
        } else {
          this.handleCoverError(new Error('上传失败'));
        }
        this.uploading = false;
        this.xhr = null;
      };
      
      xhr.onerror = () => {
        this.handleCoverError(new Error('上传失败'));
        this.uploading = false;
        this.xhr = null;
      };
      
      xhr.open('POST', this.uploadPdfUrl, true);
      xhr.send(formData);
    },
    cancelUpload() {
      if (this.xhr) {
        this.xhr.abort();
        this.xhr = null;
        this.uploading = false;
        this.uploadProgress = 0;
      }
    },
    handleCoverSuccess(response, file, fileList) {
      if(response.msg==="error"){
        this.$message.error('文件上传失败!');
      }else{
        this.fileData= {
          name: file.name,
          url: response.url,
          items: [],
        };
        if (response.imagesUrls){
          this.fileData.items = response.imagesUrls.map(item => ({
            text_en: '',
            text_cn: '',
            audio_url: '',
            image_url: item,
            audio_name: '',
            audio_size: '',
            audio_duration: '',
            isPlaying: false,
          }));
        }
        this.save();
      }
    },
    handleCoverError(err, file, fileList) {
      console.log(err);
      this.$message.error('文件上传失败!');
    },
    beforeCoverUpload(file) {
      // 如果正在上传，则不允许新的上传
      if (this.uploading) {
        this.$message.warning('请等待当前文件上传完成或取消上传');
        return false;
      }
      const isPdf = (file.type === 'application/pdf');
      const isLt2M = file.size / 1024 / 1024 / 1024 < 2;

      if (!isPdf) {
        this.$message.error('上传文件必须是PDF!');
      } else if (!isLt2M) {
        this.$message.error('上传文件大小不能超过 200MB!');
      }
      return isPdf && isLt2M;
    },

    save() {
      // 保存新增或修改的数据
      window.courseware.setData(this.fileData, () => {
        //保存数据也是异步的
        this.$message.success("实时保存成功");
      }, key);
    },

    handleAudioSuccess(res, file, index) {
      // 假设上传接口返回的音频URL在 res.url 中
      this.fileData.items[index].audio_url = res.url;
      this.fileData.items[index].audio_name = file.name;

      // 计算文件大小
      const size = file.size;
      if (size < 1024) {
        this.fileData.items[index].audio_size = size + 'B';
      } else if (size < 1024 * 1024) {
        this.fileData.items[index].audio_size = (size / 1024).toFixed(2) + 'KB';
      } else {
        this.fileData.items[index].audio_size = (size / (1024 * 1024)).toFixed(2) + 'MB';
      }

      // 获取音频时长
      const audio = new Audio(res.url);
      audio.addEventListener('loadedmetadata', () => {
        const duration = audio.duration;
        const minutes = Math.floor(duration / 60);
        const seconds = Math.floor(duration % 60);
        this.fileData.items[index].audio_duration = `${minutes}:${seconds.toString().padStart(2, '0')}`;
      });

      this.save();
    },

    // 播放/暂停音频
    togglePlay(index) {
      const audio = this.$refs['audio' + index][0];
      if (this.fileData.items[index].isPlaying) {
        audio.pause();
        this.fileData.items[index].isPlaying = false;
      } else {
        // 先停止其他正在播放的音频
        this.fileData.items.forEach((item, i) => {
          if (i !== index && item.isPlaying) {
            this.$refs['audio' + i][0].pause();
            item.isPlaying = false;
          }
        });
        audio.play();
        this.fileData.items[index].isPlaying = true;
      }
    },

    // 音频播放结束
    audioEnded(index) {
      this.fileData.items[index].isPlaying = false;
    },
    beforeAudioUpload(file) {
      const isAudio = file.type.startsWith('audio/');
      const isLt20M = file.size / 1024 / 1024 < 20;

      if (!isAudio) {
        this.$message.error('只能上传音频文件!');
        return false;
      }
      if (!isLt20M) {
        this.$message.error('音频大小不能超过 20MB!');
        return false;
      }
      return true;
    },
    deleteConf(index) {
      this.fileData.items.splice(index, 1);
      this.save();
    },
    addConfig() {
      this.fileData.items.push({
        text_en: '',
        text_cn: '',
        audio_url: '',
        image_url: '',
        audio_name: '',
        audio_size: '',
        audio_duration: '',
        isPlaying: false,
      });
      this.save();
    },
    // 图片上传成功的回调
    handleImageSuccess(res, file, index) {
      // 假设上传接口返回的图片URL在 res.url 中
      this.fileData.items[index].image_url = res.url;
      this.save();
    },

    // 图片上传前的验证
    beforeImageUpload(file) {
      const isImage = file.type.startsWith('image/');
      const isLt2M = file.size / 1024 / 1024 < 5;

      if (!isImage) {
        this.$message.error('只能上传图片文件!');
        return false;
      }
      if (!isLt2M) {
        this.$message.error('图片大小不能超过 2MB!');
        return false;
      }
      return true;
    },

    // 预览图片
    previewImage(url) {
      // 使用 Element UI 的 Image 组件预览
      const h = this.$createElement;
      this.$msgbox({
        title: '图片预览',
        message: h('img', {
          attrs: {
            src: url,
            style: 'max-width: 100%; max-height: 500px;'
          }
        }),
        showCancelButton: false,
        confirmButtonText: '关闭'
      });
    },

    // 删除图片
    removeImage(index) {
      this.$confirm('确定要删除这张图片吗?', '提示', {
        confirmButtonText: '确定',
        cancelButtonText: '取消',
        type: 'warning'
      }).then(() => {
        this.fileData.items[index].image_url = '';
        this.save();
        this.$message({
          type: 'success',
          message: '删除成功!'
        });
      }).catch(() => { });
    }
    
  }
});
