

/* 

window.courseware.getData(callback,key);  //用于获取数据
window.courseware.setData(data,callback,key);  //用于存储数据
var uploadUrl = window.courseware.uploadUrl();  //上传文件的路径
var uploadData = window.courseware.uploadData();  //上传文件必须要的参数 

*/

//对应模板的名称，这个可以不写，但是最好是能写上，同时开发多个模板的情况下如果不写这个，本地缓存可能会存在混乱
var key = "yl01";

new Vue({
  el: '#edit-data',
  created() {
    window.courseware.getData((dt) => {
      if (dt) {
        this.data = dt;
        if(!this.data.questionSets) {
          this.$set(this.data, 'questionSets', [])
        }
      }
    },key);
    window['air'].getUploadCallback = (url, data) => {
      this.uploadUrl = url;
      this.uploadData = data;
    };
    console.log('========== data ==========');
    console.log(this.data);
  },
  data() {
    return {
      //封面上传相关
      data: {
        questionSets: []
      },
      uploadUrl: window.courseware.uploadUrl(),
      uploadData: window.courseware.uploadData(),
      isPlaying: false,
      options: [
        {label: 'A', value: 'A'},
        {label: 'B', value: 'B'},
        {label: 'C', value: 'C'},
        {label: 'D', value: 'D'},
        {label: 'E', value: 'E'},
        {label: 'F', value: 'F'},
        {label: 'G', value: 'G'},
        {label: 'H', value: 'H'},
        {label: 'I', value: 'I'},
        {label: 'J', value: 'J'},
        {label: 'K', value: 'K'},
        {label: 'L', value: 'L'},
        {label: 'M', value: 'M'},
        {label: 'N', value: 'N'},
        {label: 'O', value: 'O'}, 
        {label: 'P', value: 'P'},
        {label: 'Q', value: 'Q'},
        {label: 'R', value: 'R'},
        {label: 'S', value: 'S'},
        {label: 'T', value: 'T'},
        {label: 'U', value: 'U'},
        {label: 'V', value: 'V'},
        {label: 'W', value: 'W'},
        {label: 'X', value: 'X'},
        {label: 'Y', value: 'Y'},
        {label: 'Z', value: 'Z'},
      ],
    }
  },
  methods: {
    handleAudioSuccess(res, file, qIndex) {
      // 假设上传接口返回的音频URL在 res.url 中
      this.data.questionSets[qIndex].audio.url = res.url;
      this.data.questionSets[qIndex].audio.name = file.name;

      // 计算文件大小
      const size = file.size;
      if (size < 1024) {
        this.data.questionSets[qIndex].audio.size = size + 'B';
      } else if (size < 1024 * 1024) {
        this.data.questionSets[qIndex].audio.size = (size / 1024).toFixed(2) + 'KB';
      } else {
        this.data.questionSets[qIndex].audio.size = (size / (1024 * 1024)).toFixed(2) + 'MB';
      }

      // 获取音频时长
      const audio = new Audio(res.url);
      audio.addEventListener('loadedmetadata', () => {
        const duration = audio.duration;
        const minutes = Math.floor(duration / 60);
        const seconds = Math.floor(duration % 60);
        this.data.questionSets[qIndex].audio.duration = `${minutes}:${seconds.toString().padStart(2, '0')}`;
      });

      this.save();
    },

    togglePlay(qIndex) {
      const currentAudio = this.$refs['audio_'+qIndex][0];
      for(let i = 0; i < this.data.questionSets.length; i++) {
        const audio = this.$refs['audio_'+i][0];
        if(audio) {
          audio.pause();
        }
      }
      currentAudio.play();
    },

    audioEnded() {

    },

    beforeAudioUpload(file) {
      const isAudio = file.type.startsWith('audio/');
      const isLt20M = file.size / 1024 / 1024 < 20;

      if (!isAudio) {
        this.$message.error('只能上传音频文件!');
        return false;
      }
      if (!isLt20M) {
        this.$message.error('音频大小不能超过 20MB!');
        return false;
      }
      return true;
    },

    addQuestion() {
      this.data.questionSets.push({
        letter: '',
        upperCase: false,
        lowerCase: false,
        audio: {
          url: '',
          name: '',
          size: 0,
          duration: ""
        }
      });
      this.save();
    },

    save() {
      window.courseware.setData(this.data,() => {
        this.$message.success('保存成功！');
      },key);
    }
  }
});
