

/* 

window.courseware.getData(callback,key);  //用于获取数据
window.courseware.setData(data,callback,key);  //用于存储数据
var uploadUrl = window.courseware.uploadUrl();  //上传文件的路径
var uploadData = window.courseware.uploadData();  //上传文件必须要的参数 

*/

//对应模板的名称，这个可以不写，但是最好是能写上，同时开发多个模板的情况下如果不写这个，本地缓存可能会存在混乱
var key = "yl02";

new Vue({
  el: '.edit-data',
  created() {
    window.courseware.getData((data) => {
      this.data = data || [];
    }, key);
    window['air'].getUploadCallback = (url, data) => {
      this.uploadUrl = url;
      this.uploadData = data;
    };
  },
  data() {
    return {
      data: [],
      uploadUrl: window.courseware.uploadUrl(),
      uploadData: window.courseware.uploadData(),
    }
  },
  methods: {
    handleAudioSuccess(res, file, index) {
      // 假设上传接口返回的音频URL在 res.url 中
      this.data[index].audio_url = res.url;
      this.data[index].audio_name = file.name;

      // 计算文件大小
      const size = file.size;
      if (size < 1024) {
        this.data[index].audio_size = size + 'B';
      } else if (size < 1024 * 1024) {
        this.data[index].audio_size = (size / 1024).toFixed(2) + 'KB';
      } else {
        this.data[index].audio_size = (size / (1024 * 1024)).toFixed(2) + 'MB';
      }

      // 获取音频时长
      const audio = new Audio(res.url);
      audio.addEventListener('loadedmetadata', () => {
        const duration = audio.duration;
        const minutes = Math.floor(duration / 60);
        const seconds = Math.floor(duration % 60);
        this.data[index].audio_duration = `${minutes}:${seconds.toString().padStart(2, '0')}`;
      });

      this.save();
    },

    // 播放/暂停音频
    togglePlay(index) {
      const audio = this.$refs['audio' + index][0];
      if (this.data[index].isPlaying) {
        audio.pause();
        this.data[index].isPlaying = false;
      } else {
        // 先停止其他正在播放的音频
        this.data.forEach((item, i) => {
          if (i !== index && item.isPlaying) {
            this.$refs['audio' + i][0].pause();
            item.isPlaying = false;
          }
        });
        audio.play();
        this.data[index].isPlaying = true;
      }
    },

    // 音频播放结束
    audioEnded(index) {
      this.data[index].isPlaying = false;
    },
    beforeAudioUpload(file) {
      const isAudio = file.type.startsWith('audio/');
      const isLt20M = file.size / 1024 / 1024 < 20;

      if (!isAudio) {
        this.$message.error('只能上传音频文件!');
        return false;
      }
      if (!isLt20M) {
        this.$message.error('音频大小不能超过 20MB!');
        return false;
      }
      return true;
    },
    save() {
      // 保存新增或修改的数据
      window.courseware.setData(this.data, () => {
        //保存数据也是异步的
        this.$message.success("实时保存成功");
      }, key);
    },
    deleteConf(index) {
      this.data.splice(index, 1);
      this.save();
    },
    addConfig() {
      this.data.push({
        text_en: '',
        text_cn: '',
        audio_url: '',
        image_url: '',
        audio_name: '',
        audio_size: '',
        audio_duration: '',
        isPlaying: false,
      });
      this.save();
    },
    // 图片上传成功的回调
    handleImageSuccess(res, file, index) {
      // 假设上传接口返回的图片URL在 res.url 中
      console.log(res, file, index);
      this.data[index].image_url = res.url;
      this.save();
    },

    // 图片上传前的验证
    beforeImageUpload(file) {
      const isImage = file.type.startsWith('image/');
      const isLt2M = file.size / 1024 / 1024 < 5;

      if (!isImage) {
        this.$message.error('只能上传图片文件!');
        return false;
      }
      if (!isLt2M) {
        this.$message.error('图片大小不能超过 2MB!');
        return false;
      }
      return true;
    },

    // 预览图片
    previewImage(url) {
      // 使用 Element UI 的 Image 组件预览
      const h = this.$createElement;
      this.$msgbox({
        title: '图片预览',
        message: h('img', {
          attrs: {
            src: url,
            style: 'max-width: 100%; max-height: 500px;'
          }
        }),
        showCancelButton: false,
        confirmButtonText: '关闭'
      });
    },

    // 删除图片
    removeImage(index) {
      this.$confirm('确定要删除这张图片吗?', '提示', {
        confirmButtonText: '确定',
        cancelButtonText: '取消',
        type: 'warning'
      }).then(() => {
        this.data[index].image_url = '';
        this.save();
        this.$message({
          type: 'success',
          message: '删除成功!'
        });
      }).catch(() => { });
    }
  },
  computed: {
  }
});
