# ng-template-generator

angularjs技术框架下的H5互动模板框架脚手架，基于NG-ZORRO实现快速开发基于绘玩云的H5互动课件。

# 使用简介

## 生成项目

* 登录绘玩云课件开发平台：http://staging-teach.ireadabc.com/ 
* 点击“模板管理” 菜单，然后点击“新建模板”, 填写必要的信息，在“技术选型”一项上选择“Angular”
* 点击“确定”后，列表页就会出现一个新生成的模板项目
* 在项目的卡片下找到“开发”按钮，则会弹出相对应的git地址

## 获取并启动项目

```
// xxx 是上面项目对应的Git地址
git clone xxx
cd 项目名称/
npm install
npm start

//启动成功后打开浏览器，输入：http://localhost:4200 则可以看到这个项目的初始化效果了

```

## 项目结构

|-- bin
|-- dist
|-- e2e
|-- node_modules
|-- publish
|-- src
| |-- app
| | |-- common
| | |-- form
| | |-- pipes
| | |-- play
| | |-- services
| | |-- style
| | |-- app.component.html
| | |-- app.component.scss
| | |-- app.component.ts
| | |-- app.module.ts
| |-- assets
| |-- environments
| |-- services
| |-- index.html
| |-- main.ts
| |--.......



* 其中 play 文件夹是H5模板展示页面，form文件夹是模板的配置页面
* common文件夹是以往做过的模板积累的一些比较常用的 AngularJs 的组件
* assets文件夹存放模板样式的静态资源，例如小图标、背景图片、字体、样式等等
* 其他文件夹开发者可以不做任何更改

## 开始开发

本脚手架的页面类UI框架是基于  [NG-ZORRO](https://ng.ant.design/docs/introduce/zh "With a Title") 框架实现的，在配置页面（form文件夹），一些表单输入，上传图片等组件也可以使用 NG-ZORRO 现成的组件

### 开发配置页面（form/）

配置页面主要作用是为了呈现多样化模板，提高H5模板的高复用性、灵活性提供的一个配置工具，根据H5模板的设计规划或特性，会规定某些元素是可以配置的，比如背景图片、音频、选项、标题等等等等。(课件制作者) 通过配置页面，就可以灵活的更换这些，从而形成多种多样的课件。


配置页面的开发要求很简单，我们不关心布局、样式、交互等所有实现细节与效果，只需调用两个内置的全局接口即可：

* setData 接口，用于将配置的数据存储到云端。

  此方法是一个异步的方法，接收三个必要参数

  obj: 一个json对象

  callback: 回调函数

  t_name: 模板名称

  一般使用例子如下：

  ```
  // ts语法，不能直接使用js的window对象自定义方法
  (<any> window).courseware.setData(obj, callback, t_name);
  ```

* getData 接口，用于当点击修改的时候将配置的数据从云端获取下来。

  此方法是一个异步的方法，接收两个必要参数 

  > callback: 回调函数, 回调函数里会得到云端保存的数据

  > t_name: 模板名称

  一般使用例子如下：

  ```
  // ts语法，不能直接使用js的window对象自定义方法
  const getData = (<any> window).courseware.getData;
  getData((data) => {
    //data 就是云端获取的数据，也就是setData方法存到云端的那个obj
    //模板开发者需要根据数据，依次填写到表单的相应位置，方便用户二次修改编辑
  });
  ```

### 开发展示页面（play/）

展示页面主要是呈现模板，通过H5技术，实现多样化的交互与展示方式。


展示页面更简单，开发者可以运用各种技术，实现Web端可以实现的任何效果，包括2D、3D、动画、游戏等各种场景，把表单配置的数据获取到，用于渲染相对应的页面即可：
 
* getData 接口，用于当点击修改的时候将配置的数据从云端获取下来。

  此方法是一个异步的方法，接收两个必要参数 

  > callback: 回调函数, 回调函数里会得到云端保存的数据

  > t_name: 模板名称

  一般使用例子如下：

  ```
  // ts语法，不能直接使用js的window对象自定义方法
  const getData = (<any> window).courseware.getData;
  getData((data) => {
    //data 就是云端获取的数据，也就是setData方法存到云端的那个obj
    //模板开发者需要根据数据来渲染或控制展示页面的呈现，达到模板的互动目的 
  });
  ```


  ### 补充方法

  在模板的编辑或展示过程中，还会经常遇到如下两个场景，特提供针对性的解决办法

  1)  表单录入往往需要上传图片、音视频等多媒体文件，所以脚手架内置如下方法，用于获取一个上传到云端的接口方法

  ```
  const uploadUrl = (<any> window).courseware.uploadUrl;
  const uploadData = (<any> window).courseware.uploadData;

  //例如用于NG-ZORRO的上传组件则如下写法：
  <nz-upload class="p-image-uploader" [nzDisabled]="disableUpload"
    [nzShowUploadList]="false"
    nzAccept = "image/*"
    [nzAction]="uploadUrl"    <!-- 注意这里 -->
    [nzData]="uploadData"     <!-- 注意这里 -->
    (nzChange)="handleChange($event)">
  </nz-upload>

  ```

  2)  在展示页面加载完成的时候，需要调用一下下面的方法，用于释放切换课件的遮罩层

  ```
  //此方法为固定写法，
  //其中t_name为模板名称，obj是云端存储的配置数据
  window["air"].hideAirClassLoading(t_name,obj);
  ```